/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.CorrelationMatrixCard;
import com.dataiku.dip.eda.worksheets.cards.common.HeatmapParams;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateHeaderCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class NoSelectionSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.isEmpty()) {
            return Collections.emptyList();
        }
        UnivariateAnalysisReport report = new UnivariateAnalysisReport(sniffedVariables);
        if (report.containsOnlyTop10Numerical()) {
            return Arrays.asList(this.suggestTop10Numerical(report), this.suggestCorrelationMatrix(report));
        }
        if (report.containsOnlyTop10Categorical()) {
            return Collections.singletonList(this.suggestTop10Categorical(report));
        }
        ArrayList<SuggestCards.SuggestedCard> suggestions = new ArrayList<SuggestCards.SuggestedCard>();
        suggestions.add(this.suggestTop100(report));
        if (report.canSuggestTop10Numerical()) {
            suggestions.add(this.suggestTop10Numerical(report));
        }
        if (report.canSuggestCorrelationMatrix()) {
            suggestions.add(this.suggestCorrelationMatrix(report));
        }
        if (report.canSuggestTop10Categorical()) {
            suggestions.add(this.suggestTop10Categorical(report));
        }
        if (report.canSuggestTop10LowCardinality()) {
            suggestions.add(this.suggestTop10LowCardinality(report));
        }
        return suggestions;
    }

    private SuggestCards.SuggestedCard suggestTop100(UnivariateAnalysisReport report) {
        String title = report.containsAtMost100() ? "Univariate analysis on all variables" : "Univariate analysis on the top 100 variables";
        UnivariateHeaderCard card = this.getAnalysisCard(report.top100);
        return new SuggestCards.SuggestedCard(title, card);
    }

    private SuggestCards.SuggestedCard suggestTop10Numerical(UnivariateAnalysisReport report) {
        String title = report.containsOnlyTop10Numerical() ? "Univariate analysis on all variables" : (report.containsMoreThan10Numerical ? "Univariate analysis on the top 10 numerical variables" : "Univariate analysis on all numerical variables");
        UnivariateHeaderCard card = this.getAnalysisCard(report.top10Numerical);
        return new SuggestCards.SuggestedCard(title, card);
    }

    private SuggestCards.SuggestedCard suggestTop10Categorical(UnivariateAnalysisReport report) {
        String title = report.containsOnlyTop10Categorical() ? "Univariate analysis on all variables" : (report.containsMoreThan10Categorical ? "Univariate analysis on the top 10 categorical variables" : "Univariate analysis on all categorical variables");
        UnivariateHeaderCard card = this.getAnalysisCard(report.top10Categorical);
        return new SuggestCards.SuggestedCard(title, card);
    }

    private SuggestCards.SuggestedCard suggestTop10LowCardinality(UnivariateAnalysisReport report) {
        String title = report.containsMoreThan10LowCardinality ? "Univariate analysis on the top 10 low cardinality variables" : "Univariate analysis on all low cardinality variables";
        UnivariateHeaderCard card = this.getAnalysisCard(report.top10LowCardinality);
        return new SuggestCards.SuggestedCard(title, card);
    }

    private SuggestCards.SuggestedCard suggestCorrelationMatrix(UnivariateAnalysisReport report) {
        String title = report.containsOnlyTop10Numerical() ? "Correlation matrix on all variables" : (report.containsMoreThan10Numerical ? "Correlation matrix on the top 10 numerical variables" : "Correlation matrix on all numerical variables");
        CorrelationMatrixCard card = new CorrelationMatrixCard(report.top10Numerical, CorrelationMatrixCard.CorrelationMetric.SPEARMAN, new HeatmapParams());
        return new SuggestCards.SuggestedCard(title, card);
    }

    private UnivariateHeaderCard getAnalysisCard(List<Variable> variables) {
        List sortedVariables = variables.stream().sorted(Comparator.comparing(it -> it.name)).collect(Collectors.toList());
        boolean allContinuous = sortedVariables.stream().allMatch(Variable::isContinuous);
        UnivariateHeaderCard card = new UnivariateHeaderCard();
        card.xColumns = sortedVariables;
        card.showHistogram = true;
        card.showBoxPlot = true;
        card.showQuantile = true;
        card.showSummary = true;
        card.showFrequencyTable = true;
        card.showCumulativeDistributionFunction = allContinuous;
        return card;
    }

    private static class UnivariateAnalysisReport {
        List<Variable> top100 = new ArrayList<Variable>();
        List<Variable> top10Numerical = new ArrayList<Variable>();
        List<Variable> top10Categorical = new ArrayList<Variable>();
        List<Variable> top10LowCardinality = new ArrayList<Variable>();
        boolean containsMoreThan10Numerical = false;
        boolean containsMoreThan10Categorical = false;
        boolean containsMoreThan10LowCardinality = false;
        private final int allVariablesCount;
        private boolean areTop10CategoricalAlsoLowCardinality = true;

        UnivariateAnalysisReport(List<SniffedVariable> sniffedVariables) {
            this.allVariablesCount = sniffedVariables.size();
            List allSorted = sniffedVariables.stream().sorted(Comparator.comparing(SniffedVariable::getInterestScore).reversed()).collect(Collectors.toList());
            for (SniffedVariable sniffed : allSorted) {
                this.addToTop100(sniffed);
                if (sniffed.holdsNumericalValues()) {
                    this.addToTop10Numerical(sniffed);
                }
                if (sniffed.isLikelyCategorical()) {
                    this.addToTop10Categorical(sniffed);
                }
                if (!sniffed.hasVeryLowCardinality()) continue;
                this.addToTop10LowCardinality(sniffed);
            }
        }

        boolean containsOnlyTop10Numerical() {
            return this.allVariablesCount == this.top10Numerical.size();
        }

        boolean containsOnlyTop10Categorical() {
            return this.allVariablesCount == this.top10Categorical.size();
        }

        boolean containsAtMost100() {
            return this.allVariablesCount <= 100;
        }

        boolean canSuggestTop10Numerical() {
            return this.top10Numerical.size() > 0;
        }

        boolean canSuggestCorrelationMatrix() {
            return this.top10Numerical.size() > 1;
        }

        boolean canSuggestTop10Categorical() {
            return this.top10Categorical.size() > 0;
        }

        boolean canSuggestTop10LowCardinality() {
            return this.top10LowCardinality.size() > 0 && !this.areTop10CategoricalAlsoLowCardinality;
        }

        private void addToTop100(SniffedVariable sniffed) {
            if (this.top100.size() < 100) {
                this.top100.add(Suggester.toVariable(sniffed));
            }
        }

        private void addToTop10Numerical(SniffedVariable sniffed) {
            if (this.top10Numerical.size() < 10) {
                this.top10Numerical.add(Suggester.toContinuousVariable(sniffed));
            } else {
                this.containsMoreThan10Numerical = true;
            }
        }

        private void addToTop10Categorical(SniffedVariable sniffed) {
            if (this.top10Categorical.size() < 10) {
                this.top10Categorical.add(Suggester.toCategoricalVariable(sniffed));
                if (!sniffed.hasVeryLowCardinality()) {
                    this.areTop10CategoricalAlsoLowCardinality = false;
                }
            } else {
                this.containsMoreThan10Categorical = true;
            }
        }

        private void addToTop10LowCardinality(SniffedVariable sniffed) {
            if (this.top10LowCardinality.size() < 10) {
                this.top10LowCardinality.add(Suggester.toCategoricalVariable(sniffed));
            } else {
                this.containsMoreThan10LowCardinality = true;
            }
        }
    }
}

