/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.export.ExportDAO;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;

public abstract class ExportFutureThreadBase
extends SimpleFutureThread<ExportResult> {
    protected final SharedState state = new SharedState();
    protected final FuturePayload futurePayload;
    protected final WarningsContext warningsContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.export.thread");

    public ExportFutureThreadBase(AuthCtx user, ExportInput input, String exportId) {
        super(user);
        this.futurePayload = ExportFutureThreadBase.buildFuturePayload(input, exportId);
        this.warningsContext = new WarningsContext();
    }

    public static FuturePayload buildFuturePayload(ExportInput input, String exportId) {
        FuturePayload fp = new FuturePayload();
        fp.targets.add(input.getSource());
        fp.action = "export";
        fp.displayName = "Running export";
        fp.withExtra("exportId", (Object)exportId);
        return fp;
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    protected void saveStatus(ExportStatus status) throws IOException {
        ((ExportDAO)SpringUtils.getBean(ExportDAO.class)).writeStatus(status);
    }

    protected ExportResult getResultOK() {
        ExportResult result = new ExportResult();
        result.isSuccess = true;
        result.warnings = this.warningsContext.getOutput();
        return result;
    }

    protected ExportResult getResultNOK() {
        ExportResult result = new ExportResult();
        result.isSuccess = false;
        result.warnings = this.warningsContext.getOutput();
        return result;
    }

    protected void terminateSlaveThreads(Thread inputThread, Thread outputThread) {
        try {
            long waitTime = 200L;
            while (inputThread.isAlive() || outputThread.isAlive()) {
                if (inputThread.isAlive()) {
                    logger.debug((Object)"Kill export input thread");
                    inputThread.interrupt();
                }
                if (outputThread.isAlive()) {
                    logger.debug((Object)"Kill export output thread");
                    outputThread.interrupt();
                }
                Thread.sleep(waitTime);
                waitTime = (long)Math.min(1.5 * (double)waitTime, 20000.0);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Object)"Export thread interrupted while terminating. Possible resource leak.");
        }
    }

    protected class SharedState {
        private UniversalSingleThreadPuller.Stream bidirectionnalStream = new UniversalSingleThreadPuller.Stream();
        MonitoredForwarder monitoredOutputStream;
        private Exception inputException;
        private Exception outputException;
        private boolean outputFinished;
        private boolean inputFinished;
        private boolean inputInitialized;
        private Schema schema;
        private final Object schemaCV;
        ColumnFactory cf;
        private long inputSize;

        public SharedState() {
            this.monitoredOutputStream = new MonitoredForwarder(this.bidirectionnalStream);
            this.schema = null;
            this.schemaCV = new Object();
            this.inputSize = -1L;
            this.cf = new StreamColumnFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Schema waitForSchema() throws InterruptedException {
            Object object = this.schemaCV;
            synchronized (object) {
                while (this.schema == null) {
                    this.schemaCV.wait();
                }
            }
            return this.schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setSchema(Schema schema) {
            Object object = this.schemaCV;
            synchronized (object) {
                this.schema = schema;
                this.schemaCV.notifyAll();
            }
        }

        protected void propagateFailureIfAny() throws Exception {
            if (this.getInputException() != null) {
                throw this.getInputException();
            }
            if (this.getOutputException() != null) {
                throw this.getOutputException();
            }
        }

        public synchronized ProcessorOutput getOutputStream() {
            return this.monitoredOutputStream;
        }

        public synchronized RowInputStream getInputStream() {
            return this.bidirectionnalStream;
        }

        public synchronized long getNbRecords() {
            return this.monitoredOutputStream.getNbRecords();
        }

        public synchronized void setInputFailed(Exception e) {
            this.outputException = e;
        }

        public synchronized void setOutputFailed(Exception e) {
            this.outputException = e;
        }

        public synchronized Exception getOutputException() {
            return this.outputException;
        }

        public synchronized Exception getInputException() {
            return this.inputException;
        }

        public synchronized void setOutputFinished() {
            this.outputFinished = true;
        }

        public synchronized void setInputFinished() {
            this.inputFinished = true;
        }

        public synchronized long getInputSize() {
            return this.inputSize;
        }

        public synchronized boolean isExportFinished() {
            return this.inputFinished && this.outputFinished;
        }

        public synchronized boolean isInputInitialized() {
            return this.inputInitialized;
        }

        public synchronized boolean isInputInitializedAndStarted() {
            return this.inputInitialized && this.monitoredOutputStream != null && this.monitoredOutputStream.isConsideredAsStarted();
        }

        public synchronized void setInputInitialized(long inputSize) {
            this.inputInitialized = true;
            this.inputSize = inputSize;
        }
    }

    public static class ExportResult {
        boolean isSuccess;
        WarningsContext.SerializedWarnings warnings;
    }

    protected class MonitoredForwarder
    extends FilteringProcessorOutput {
        private volatile boolean firstRowReceived;
        private volatile boolean emittedLastRow;
        private volatile boolean cancelled;
        private long nbRecords;

        public MonitoredForwarder(ProcessorOutput downstream) {
            super(downstream);
            this.nbRecords = 0L;
        }

        public boolean isConsideredAsStarted() {
            return this.firstRowReceived || this.emittedLastRow || this.cancelled;
        }

        public void emitRow(Row row) throws Exception {
            this.firstRowReceived = true;
            this.downstream.emitRow(row);
            if (row != null) {
                ++this.nbRecords;
            }
        }

        public void lastRowEmitted() throws Exception {
            if (this.emittedLastRow) {
                throw new RuntimeException("lastRowEmitted() called multiple times");
            }
            this.emittedLastRow = true;
            super.lastRowEmitted();
        }

        public long getNbRecords() {
            return this.nbRecords;
        }

        public boolean isLastRowEmitted() {
            return this.emittedLastRow;
        }
    }
}

