/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition.custom;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.exposition.LocalProcessExposition;
import com.dataiku.dip.exposition.custom.CustomExpositionsService;
import com.dataiku.dip.exposition.custom.LoadedExposition;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CustomExpositionMeta
implements ExpositionMeta {
    private final LoadedExposition loaded;
    private final CustomExpositionsService customExpositionsService;
    private ExpositionMeta meta;
    private String metaHash;
    private static final Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    public CustomExpositionMeta(LoadedExposition loaded, CustomExpositionsService customExpositionsService) {
        this.loaded = loaded;
        this.customExpositionsService = customExpositionsService;
    }

    private ExpositionMeta getSubMeta() {
        try {
            String newHash;
            File libFolder = this.customExpositionsService.getPluginJavaLibFolder(this.loaded.getOwnerPluginId());
            if (!libFolder.exists()) {
                newHash = "not built";
            } else {
                Object[] contents = libFolder.list();
                Arrays.sort(contents);
                ArrayList hashElems = Lists.newArrayList();
                for (Object content : contents) {
                    File f = new File(libFolder, (String)content);
                    hashElems.add(String.format("%s-%s-%s", f.getName(), f.length(), f.lastModified()));
                }
                newHash = DKUtils.md5Base64((String)Joiner.on((String)",").join((Iterable)hashElems));
            }
            if (this.metaHash == null || !this.metaHash.equals(newHash)) {
                logger.info((Object)"Hash of java libs changed, invalidating exposition code");
                this.meta = null;
            }
            this.metaHash = newHash;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to hash the plugin lib folder, reloading exposition code", (Throwable)e);
            this.meta = null;
        }
        if (this.meta == null) {
            try {
                ClassLoader classLoader = this.customExpositionsService.getClassloader(this.loaded);
                this.meta = (ExpositionMeta)new PluginClazzLoader(classLoader).loadClazz(this.loaded.getDesc().metaClass);
            }
            catch (Throwable e) {
                logger.warn((Object)"Failed to load actual meta, running with load process meta", e);
                this.meta = LocalProcessExposition.META;
            }
        }
        return this.meta;
    }

    @Override
    public String getType() {
        return this.loaded.expositionType;
    }

    @Override
    public Class<? extends ExpositionParams> getParamsClass() {
        return this.getSubMeta().getParamsClass();
    }

    @Override
    public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
        ExpositionDesc desc = this.loaded.getDesc();
        return desc.withType(this.getType());
    }

    @Override
    public boolean handles(ContainerExecRuntimeConfig containerConfig) {
        return this.getSubMeta().handles(containerConfig);
    }

    @Override
    public boolean handles(Exposables.ExposableKind kind) {
        return this.getSubMeta().handles(kind);
    }

    @Override
    public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
        return this.getSubMeta().handles(containerType);
    }

    @Override
    public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
        ExpositionMeta subMeta = this.getSubMeta();
        if (exposition.params != null) {
            exposition.params = (ExpositionParams)JSON.parse((String)JSON.json((Object)exposition.params), subMeta.getParamsClass());
        }
        return subMeta.buildHandler(authCtx, projectKey, containerConfig, exposition, endpointConsumer);
    }

    @Override
    public long getMaxStartWait(AuthCtx authCtx) {
        return this.getSubMeta().getMaxStartWait(authCtx);
    }

    @Override
    public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
    }
}

