/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.google.refine.expr.Evaluable;
import com.google.refine.grel.Function;
import com.google.refine.grel.ast.ControlCallExpr;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.grel.ast.OperatorCallExpr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class PreviousRowsRequirements {
    private final Map<String, Integer> countByColumns = new HashMap<String, Integer>();

    public PreviousRowsRequirements(Evaluable ev) {
        this.computeCountByColumns(ev);
        this.countByColumns.values().removeIf(v -> v == null || v == 0);
    }

    public boolean requirePreviousRows() {
        return !this.countByColumns.isEmpty();
    }

    public Map<String, Integer> getCountByColumns() {
        return this.countByColumns;
    }

    private void computeCountByColumns(Evaluable ev) {
        Evaluable[] args = null;
        if (ev instanceof ControlCallExpr) {
            args = ((ControlCallExpr)ev)._args;
        } else if (ev instanceof FunctionCallExpr) {
            Map<String, Integer> requestedRows;
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)ev;
            Function function = functionCallExpr._function;
            args = functionCallExpr._args;
            if (function.requirePreviousRows() && (requestedRows = function.getNumberOfPreviousRowsRequiredByColumns(this.evaluateLiteralOnly(args))) != null) {
                requestedRows.forEach((key, value) -> this.countByColumns.merge((String)key, (Integer)value, Math::max));
            }
        } else if (ev instanceof OperatorCallExpr) {
            args = ((OperatorCallExpr)ev)._args;
        }
        if (args != null) {
            for (Evaluable arg : args) {
                this.computeCountByColumns(arg);
            }
        }
    }

    private Object[] evaluateLiteralOnly(Evaluable[] args) {
        return ((Stream)Arrays.stream(args).sequential()).map(arg -> arg instanceof LiteralExpr ? ((LiteralExpr)arg)._value : null).toArray();
    }
}

