/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ExternalInfrasUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.externalinfras.utils");

    private ExternalInfrasUtils() {
    }

    @Nonnull
    public static ProxySettings getProxy(@Nullable DSSConnection connection) {
        boolean useProxy;
        if (Objects.nonNull(connection)) {
            useProxy = connection.useGlobalProxy;
            if (useProxy) {
                logger.infoV("Using proxy settings as configured in the %s connection.", new Object[]{connection.getType()});
            } else {
                logger.infoV("Not using proxy settings since it is disabled in the %s connection.", new Object[]{connection.getType()});
            }
        } else {
            logger.info((Object)"Using global proxy settings since no connection is defined.");
            useProxy = true;
        }
        if (useProxy) {
            return ApplicationConfigurator.getProxySettings();
        }
        return new ProxySettings();
    }

    @Nullable
    public static DSSConnection getAndCheckConnection(AuthCtx authCtx, @Nullable String connectionName) throws IllegalArgumentException, DKUSecurityException, IOException {
        if (StringUtils.isNotBlank((String)connectionName)) {
            ConnectionsDAO cdao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
            DSSConnection conn = cdao.getMandatoryConnection(authCtx, connectionName);
            if (!conn.isFreelyUsableBy(authCtx)) {
                throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
            }
            return conn;
        }
        return null;
    }
}

