/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.sagemaker;

import com.dataiku.dip.externalinfras.ExternalInfrasInputValidator;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SageMakerInputValidator
extends ExternalInfrasInputValidator {
    private static final Pattern SAGEMAKER_ENDPOINT_NAME_PATTERN = Pattern.compile("^(?!-)(?!.*-$)[a-zA-Z0-9-]{1,63}$");
    private static final String SAGEMAKER_REGION_NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-]{0,30}\\d$";

    public static void validateRegionName(@Nullable String regionName) {
        if (StringUtils.isEmpty((CharSequence)regionName)) {
            throw new IllegalArgumentException("SageMaker region should not be empty.");
        }
        if (!SageMakerInputValidator.matches(Pattern.compile(SAGEMAKER_REGION_NAME_PATTERN), regionName)) {
            throw new IllegalArgumentException(String.format("Invalid SageMaker region: %s", regionName));
        }
    }

    public static void validateEndpointName(String endpointName) {
        if (StringUtils.isEmpty((CharSequence)endpointName)) {
            throw new IllegalArgumentException("SageMaker endpoint name should not be empty.");
        }
        if (!SageMakerInputValidator.matches(SAGEMAKER_ENDPOINT_NAME_PATTERN, endpointName)) {
            throw new IllegalArgumentException(String.format("Invalid SageMaker endpoint name: %s", endpointName));
        }
    }
}

