/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.ParamDesc;

public abstract class FormatMeta<TFormat extends FormatExtractor, TFormatParams extends FormatParams> {
    public TranslationService translationService;
    public String lang;

    public void setTranslation(TranslationService translationService, String lang) {
        this.translationService = translationService;
        this.lang = lang;
    }

    public String translate(String id, String defaultValue) {
        if (this.lang == null) {
            return defaultValue;
        }
        return this.translate(this.lang, id, defaultValue);
    }

    public String translate(String lang, String id, String defaultValue) {
        if (this.translationService == null) {
            this.translationService = (TranslationService)SpringUtils.getBean(TranslationService.class);
        }
        return this.translationService.translate(lang, id, defaultValue, new Object[0]);
    }

    public abstract String getType();

    public abstract String getLabel();

    public abstract SchemaDetection.SchemaHandlingType getSchemaHandlingType();

    public abstract ParamDesc[] getParams();

    public abstract Class<? extends FormatParams> paramsClass();

    public abstract FormatExtractor build(AuthCtx var1, String var2, FormatParams var3) throws CodedException;

    public abstract OutputFormatter buildFormatter(AuthCtx var1, String var2, FormatParams var3);
}

