/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.charts.execution;

import com.dataiku.dip.analysis.docgen.model.PuppeteerStepType;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import java.util.List;

public class DomElementEnrichedExport
extends EnrichedExport {
    public final List<Target> elements;
    public final String rootUrl;

    public DomElementEnrichedExport(String rootUrl, String exportId, String projectKey, ExportFormat format, List<Target> elements, boolean browserSandBoxing) {
        super(exportId, projectKey, format, browserSandBoxing);
        this.elements = elements;
        this.rootUrl = rootUrl;
    }

    public static class Target {
        public String puppeteerConfigName;
        public String placeholderName;
        public String url;
        public List<Step> steps;

        public static class Step {
            public static final int DEFAULT_BOTTOM_MARGIN = -1;
            public static final String DEFAULT_LOADED_STATE_FIELD = "puppeteerHook_elementContentLoaded";
            public PuppeteerStepType type;
            public String cssSelector;
            public boolean waitForAnimations;
            public String loadedStateField;
            public int bottomMargin;
            public boolean hasParameter;
            public String parameterValue;

            public Step(PuppeteerStepType type, String cssSelector, boolean waitForAnimations, String loadedStateField) {
                this.type = type;
                this.cssSelector = cssSelector;
                this.waitForAnimations = waitForAnimations;
                this.loadedStateField = loadedStateField;
                this.hasParameter = false;
            }

            public Step(PuppeteerStepType type, String cssSelector) {
                this.type = type;
                this.cssSelector = cssSelector;
                this.waitForAnimations = false;
                this.loadedStateField = DEFAULT_LOADED_STATE_FIELD;
                this.bottomMargin = -1;
                this.hasParameter = false;
            }

            public Step waitForAnimations() {
                this.waitForAnimations = true;
                return this;
            }

            public Step withLoadedStateField(String loadedStateField) {
                this.loadedStateField = loadedStateField;
                return this;
            }

            public Step withBottomMargin(int bottomMargin) {
                this.bottomMargin = bottomMargin;
                return this;
            }

            public Step withParameter() {
                this.hasParameter = true;
                return this;
            }

            public void setParameterValue(String parameterValue) {
                this.parameterValue = parameterValue;
            }

            public Step deepCopy() {
                Step step = new Step(this.type, this.cssSelector);
                step.waitForAnimations = this.waitForAnimations;
                step.loadedStateField = this.loadedStateField;
                step.bottomMargin = this.bottomMargin;
                step.hasParameter = this.hasParameter;
                step.parameterValue = this.parameterValue;
                return step;
            }
        }
    }
}

