/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveServer2HiveMetastoreSynchronizer;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class MetastoreSynchronizationUtils {
    public static boolean isSynchronizationPossible(ClusterSettings clusterSettings) {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        switch (gs.metastoreCatalogsSettings.synchronizeTo.flavor) {
            case AWS_GLUE: {
                return true;
            }
            case DSS_INTERNAL: {
                return true;
            }
            case HIVESERVER2: {
                return HiveConfigurator.isHiveInstalled() && clusterSettings.getHiveSettings().enabled;
            }
        }
        throw new Error("unreachable");
    }

    public static SynchronizationRequestedStatus synchronizationRequested(AuthCtx authCtx, Dataset ds) throws IOException {
        if (ds.getParams() instanceof HDFSDatasetHandler.Config) {
            HDFSDatasetHandler.Config params = ds.getParamsAs(HDFSDatasetHandler.Config.class);
            if (params.metastoreSynchronizationEnabled) {
                try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(authCtx, ds);){
                    if (handler.getConnection().params.hiveSynchronizationMode == HDFSConnection.HiveSynchronizationMode.NO_SYNC) {
                        HiveServer2HiveMetastoreSynchronizer.logger.info((Object)("Hive Metastore sync is disabled on connection '" + handler.getConnection().name + "'"));
                        SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.notRequested("Metastore sync disabled on connection");
                        return synchronizationRequestedStatus;
                    }
                    if (StringUtils.isBlank((String)handler.getResolvedHiveTableRef(false).getSchemaNullIfBlank())) {
                        SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.notRequested("No fallback database name defined on connection");
                        return synchronizationRequestedStatus;
                    }
                    SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.requested();
                    return synchronizationRequestedStatus;
                }
            }
        } else if (ds.getParams() instanceof AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig) {
            AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig metastoreAwareDatasetParams = ds.getParamsAs(AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig.class);
            if (metastoreAwareDatasetParams.metastoreSynchronizationEnabled) {
                try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(authCtx, ds);){
                    HDFSConnection.HiveSynchronizationMode mode;
                    DSSConnection conn = ((BlobLikeDatasetHandler)handler).getConnection();
                    if (conn instanceof EC2Connection) {
                        mode = ((EC2Connection)conn).params.metastoreSynchronizationMode;
                    } else if (conn instanceof AzureConnection) {
                        mode = ((AzureConnection)conn).params.metastoreSynchronizationMode;
                    } else if (conn instanceof GCSConnection) {
                        mode = ((GCSConnection)conn).params.metastoreSynchronizationMode;
                    } else {
                        throw new IOException("Unexpected connection type: " + String.valueOf(conn.getClass()) + " for dataset " + ds.getFullName());
                    }
                    if (mode == HDFSConnection.HiveSynchronizationMode.NO_SYNC) {
                        HiveServer2HiveMetastoreSynchronizer.logger.info((Object)("Metastore sync is disabled on connection '" + conn.name + "'"));
                        SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.notRequested("Metastore sync disabled on connection");
                        return synchronizationRequestedStatus;
                    }
                    if (StringUtils.isBlank((String)handler.getResolvedHiveTableRef(false).getSchemaNullIfBlank())) {
                        SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.notRequested("No fallback database name defined on connection");
                        return synchronizationRequestedStatus;
                    }
                    SynchronizationRequestedStatus synchronizationRequestedStatus = SynchronizationRequestedStatus.requested();
                    return synchronizationRequestedStatus;
                }
            }
        }
        return SynchronizationRequestedStatus.notRequested("Connection is not compatible with a metastore");
    }

    public static class SynchronizationRequestedStatus {
        public boolean requested;
        public String reason;

        private static SynchronizationRequestedStatus requested() {
            SynchronizationRequestedStatus ret = new SynchronizationRequestedStatus();
            ret.requested = true;
            return ret;
        }

        private static SynchronizationRequestedStatus notRequested(String reason) {
            SynchronizationRequestedStatus ret = new SynchronizationRequestedStatus();
            ret.requested = false;
            ret.reason = reason;
            return ret;
        }
    }
}

