/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.input.formats.parquet.ConverterFactory;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.json.JSONException;
import org.json.JSONObject;

class ObjectConverter
extends GroupConverter {
    private static Logger logger = Logger.getLogger(ObjectConverter.class);
    private final ParentValueContainer parent;
    private final ArrayList<Converter> converters;
    private final Object[] values;
    private final GroupType parquetType;
    private final ConverterFactory cf;
    private JSONObject jsonObject;

    public ObjectConverter(ConverterFactory cf, GroupType parquetType, List<SchemaColumn> columns, ParentValueContainer parent) {
        this.parent = parent;
        this.cf = cf;
        this.converters = new ArrayList();
        this.parquetType = parquetType;
        for (int i = 0; i < parquetType.getFieldCount(); ++i) {
            final int fieldIdx = i;
            this.converters.add(cf.createConverter(parquetType.getType(i), columns != null && columns.size() > i ? columns.get(i) : null, new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ObjectConverter.this.values[fieldIdx] = value;
                }
            }));
        }
        this.values = new Object[this.converters.size()];
    }

    public Converter getConverter(int i) {
        return this.converters.get(i);
    }

    public void start() {
        this.jsonObject = new JSONObject();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public void end() {
        for (int i = 0; i < this.values.length; ++i) {
            Object val = this.values[i];
            try {
                if (val != null) {
                    this.jsonObject.put(this.parquetType.getFieldName(i), this.values[i]);
                    continue;
                }
                if (!this.cf.getRepresentsNullFields()) continue;
                this.jsonObject.put(this.parquetType.getFieldName(i), JSONObject.NULL);
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException("Unable to read struct-like object", e);
            }
        }
        if (this.jsonObject != null) {
            this.parent.add(this.jsonObject);
        }
        this.jsonObject = null;
    }
}

