/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.input.formats.parquet.ConverterFactory;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.Type;
import org.json.JSONArray;

class PigArrayConverter
extends GroupConverter {
    private static Logger logger = Logger.getLogger(PigArrayConverter.class);
    private final ParentValueContainer parent;
    private final Converter elementConverter;
    private JSONArray jsonArray;

    public PigArrayConverter(ConverterFactory cf, Type parquetType, SchemaColumn sc, ParentValueContainer parent) {
        this.parent = parent;
        Type bagType = parquetType.asGroupType().getType(0);
        this.elementConverter = cf.createConverter(bagType, sc, new ParentValueContainer(){

            @Override
            void add(Object value) {
                PigArrayConverter.this.jsonArray.put(value);
            }
        });
    }

    public Converter getConverter(int i) {
        return this.elementConverter;
    }

    public void start() {
        this.jsonArray = new JSONArray();
    }

    public void end() {
        if (this.jsonArray != null) {
            this.parent.add(this.jsonArray);
        }
        this.jsonArray = null;
    }
}

