/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.misc;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class TwilioScenarioIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        public Class<? extends IntegrationChannelParams> paramsClass() {
            return TwilioIntegrationChannelParams.class;
        }

        public String getType() {
            return "twilio";
        }

        public String getAssociatedIntegrationType() {
            return "twilio-scenario";
        }
    };
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "twilio-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return TwilioScenarioIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new TwilioScenarioIntegrationHandler(authCtx, messaging.getConfigurationAs(TwilioScenarioIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    private final TwilioScenarioIntegrationParams params;
    private final TwilioIntegrationChannelParams channelParams;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO channelsDAO;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scenarios.reporters.twilio");

    public TwilioScenarioIntegrationHandler(AuthCtx authCtx, TwilioScenarioIntegrationParams params, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        IntegrationChannel channel;
        this.params = params;
        SpringUtils.getInstance().autowire((Object)this);
        try (Transaction t = this.transactionService.beginRead();){
            channel = this.channelsDAO.getMandatory(params.channelId);
        }
        if (permissionCheckContext.checkCanUseIntegrationChannel) {
            this.integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, channel);
        }
        this.channelParams = (TwilioIntegrationChannelParams)channel.getConfigurationAs(TwilioIntegrationChannelParams.class);
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        ScenarioReportEvent sre = (ScenarioReportEvent)event;
        StrSubstitutor substitutor = new StrSubstitutor((StrLookup)sre.lookup);
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("To", this.params.toNumber));
        postParameters.add((NameValuePair)new BasicNameValuePair("From", this.channelParams.fromNumber));
        postParameters.add((NameValuePair)new BasicNameValuePair("Body", substitutor.replace(this.params.message)));
        logger.info((Object)("Sending to Twilio using parameters: " + JSON.json(postParameters)));
        String url = String.format("https://api.twilio.com/2010-04-01/Accounts/%s/Messages.json", this.channelParams.accountSid);
        AbstractHttpIntegrationEventHandler.RequestResponse response = this.postRequest(url, this.channelParams.useProxy, postParameters, TwilioScenarioIntegrationHandler.basicAccessAuthHeader(this.channelParams.accountSid, this.channelParams.authToken));
        if (response.statusCode != 201) {
            throw new Exception("API call to post message on Twilio failed : " + response.statusCode + " with reason " + response.statusReason);
        }
        logger.info((Object)String.format("Twilio responded %d (%s): %s", response.statusCode, response.statusReason, response.content));
    }

    public static class TwilioScenarioIntegrationParams
    implements IntegrationParams {
        public String channelId;
        public String toNumber;
        public String message;
    }

    public static class TwilioIntegrationChannelParams
    extends AbstractHttpIntegrationEventHandler.HTTPChannelConfiguration {
        public String accountSid;
        public String authToken;
        public String fromNumber;
    }
}

