/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.anthropic.api.AnthropicChatResponse;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AnthropicChatResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.anthropic.api");

    private AnthropicChatResponseAdapter() {
    }

    public static LLMClient.SimpleCompletionResponse adapt(AnthropicChatResponse response) {
        if (response.content == null || response.content.isEmpty()) {
            throw new IllegalArgumentException("Empty chat response");
        }
        long nTexts = response.content.stream().filter(AnthropicChatResponse.TextPart.class::isInstance).count();
        if (nTexts > 1L) {
            logger.warn((Object)String.format("The chat response contains %d text fragments, only using the first one", nTexts));
        }
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        resp.finishReason = FinishReasonResponseAdapter.adapt(response.stopReason);
        Optional<AnthropicChatResponse.TextPart> optionalText = response.content.stream().filter(AnthropicChatResponse.TextPart.class::isInstance).map(AnthropicChatResponse.TextPart.class::cast).findFirst();
        optionalText.ifPresent(textPart -> {
            resp.text = textPart.text;
        });
        List toolCalls = response.content.stream().filter(AnthropicChatResponse.ToolUsePart.class::isInstance).map(AnthropicChatResponse.ToolUsePart.class::cast).map(AnthropicChatResponseAdapter::adapt).collect(Collectors.toList());
        if (!toolCalls.isEmpty()) {
            resp.toolCalls = toolCalls;
        }
        resp.promptTokens = response.usage.inputTokens;
        resp.completionTokens = response.usage.outputTokens;
        return resp;
    }

    private static LLMClient.AbstractToolCall adapt(AnthropicChatResponse.ToolUsePart tu) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = tu.name;
        function.arguments = JSON.json((Object)tu.input);
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = tu.id;
        ftc.function = function;
        return ftc;
    }
}

