/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.promptstudio;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedPromptStudiosDAO
extends AbstractStandardDAO<PromptStudio>
implements PromptStudioDAO {
    @Override
    protected PromptStudio getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        PromptStudio lt = unsafe ? (PromptStudio)tr.readObjectUnsafe(rf, PromptStudio.class) : (PromptStudio)tr.readObject(rf, PromptStudio.class);
        lt.id = id;
        lt.projectKey = projectKey;
        return lt;
    }

    @Override
    protected List<PromptStudio> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile promptStudiosFolder = this.promptStudiosFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<PromptStudio> ret = new ArrayList<PromptStudio>();
        if (tr.isDirectory(promptStudiosFolder)) {
            for (RelFile f : tr.listFiles(promptStudiosFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    PromptStudio task = (PromptStudio)this.getMandatory(projectKey, id, unsafe);
                    ret.add(task);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read prompt studio file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Prompt studio id is not specified");
        return new RelFile(this.promptStudiosFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.PROMPT_STUDIO.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile promptStudioFile = this.getDAOFile(projectKey, id);
        t.deleteFile(promptStudioFile);
        File promptStudioFolder = this.promptStudioBaseFolder(projectKey, id);
        if (promptStudioFolder.exists()) {
            DKUFileUtils.forceDelete((File)promptStudioFolder);
        }
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile promptStudiosFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(promptStudiosFolder = this.promptStudiosFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(promptStudiosFolder).size();
    }

    private RelFile promptStudiosFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "prompt-studios"});
    }

    private File promptStudioBaseFolder(String projectKey, String psId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"prompt-studios", projectKey, psId});
    }
}

