/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.metrics.checks.CheckType;
import com.dataiku.dip.metrics.checks.CustomPythonCheckDesc;
import com.dataiku.dip.metrics.checks.CustomPythonCheckType;
import com.dataiku.dip.metrics.checks.LoadedPythonCheck;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonChecksService
extends CustomPythonElementService<CustomPythonCheckDesc, LoadedPythonCheck> {
    @Override
    public String getFolderName() {
        return "python-checks";
    }

    @Override
    public String getPrefix() {
        return "check";
    }

    @Override
    public Class<CustomPythonCheckDesc> getDescClass() {
        return CustomPythonCheckDesc.class;
    }

    @Override
    public Class<LoadedPythonCheck> getLoadedDescClass() {
        return LoadedPythonCheck.class;
    }

    @Override
    protected void removeElement(LoadedPythonCheck desc) {
    }

    @Override
    protected String getCodeExtension(LoadedPythonCheck desc) {
        return ".py";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "custom_python_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonCheck load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonCheck loaded = new LoadedPythonCheck(elementId, pluginId, elementType, (CustomPythonCheckDesc)JSON.parseFile((File)file, CustomPythonCheckDesc.class));
        CustomPythonCheckType checkType = new CustomPythonCheckType(loaded, this);
        CheckType.register(checkType);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonCheckDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonChecksService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

