/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;

public abstract class JdbcEngine
implements MetricsEngine {
    protected final Dataset dataset;
    protected final Partition partition;
    protected SQLDialect dialect;
    protected SQLConnectionProvider.SQLConnectionData connectionData;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.sql.base");

    public abstract void setupConnection(AuthCtx var1) throws IOException, DKUSecurityException, SQLException;

    public abstract QueryBunch buildQuery(AuthCtx var1, List<MetricComputation> var2, Map<String, String> var3) throws Exception;

    public abstract Map<Metric, String> getAggregates(QueryRunResult var1, List<MetricComputation> var2) throws Exception;

    public JdbcEngine(Dataset dataset, Partition partition) {
        this.dataset = dataset;
        this.partition = partition;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public ExpressionBuilder getPartitionFilter() {
        if (!MetricsComputationService.isFullDataset(this.dataset, this.partition)) {
            ExpressionBuilder builder = ExpressionUtils.getPartitionFilterClause(this.dataset.getPartitioningSchema(), this.dataset, (List<Partition>)Lists.newArrayList((Object[])new Partition[]{this.partition}), this.dialect);
            return builder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Metric, String> compute(List<MetricComputation> computations, MetricsComputationService.MetricsEngineRunReport report, FutureService futureService, AuthCtx authCtx, Map<String, String> alreadyComputed) throws Exception {
        int i;
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forMetrics((AuthCtx)authCtx, (String)this.dataset.getProjectKey(), (String)this.dataset.getName());
        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)cruContext);
        this.setupConnection(authCtx);
        QueryBunch queryBunch = this.buildQuery(authCtx, computations, alreadyComputed);
        logger.info((Object)("aggregate using jdbc with query : " + queryBunch.query));
        if (queryBunch.preQueries.size() > 0) {
            logger.info((Object)("pre-queries : " + Joiner.on((String)"\n").join(queryBunch.preQueries)));
        }
        if (queryBunch.postQueries.size() > 0) {
            logger.info((Object)("post-queries : " + Joiner.on((String)"\n").join(queryBunch.postQueries)));
        }
        HashMap variables = Maps.newHashMap();
        StrSubstitutor substitutor = new StrSubstitutor((Map)variables);
        if (this.partition != null && !this.partition.isNP()) {
            for (Map.Entry dimensionValue : this.partition.getDimensionValues().entrySet()) {
                variables.put((String)dimensionValue.getKey(), ((DimensionValue)dimensionValue.getValue()).id());
            }
        }
        for (i = 0; i < queryBunch.preQueries.size(); ++i) {
            queryBunch.preQueries.set(i, substitutor.replace(queryBunch.preQueries.get(i)));
        }
        queryBunch.query = substitutor.replace(queryBunch.query);
        for (i = 0; i < queryBunch.postQueries.size(); ++i) {
            queryBunch.postQueries.set(i, substitutor.replace(queryBunch.postQueries.get(i)));
        }
        if (queryBunch.selectedItemsCount == 0) {
            return Maps.newHashMap();
        }
        HashMap metricsValues = Maps.newHashMap();
        final SQLQueryRuntime queryRuntime = new SQLQueryRuntime(queryBunch, this.connectionData, authCtx, this.dataset.getProjectKey());
        try {
            queryRuntime.init(1000);
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        queryRuntime.cancel();
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Failed to cancel SQL query", (Throwable)e);
                    }
                }
            });){
                QueryRunResult result = queryRuntime.getPage(0, 1000, null);
                if (!result.success) {
                    throw new Exception("Query failed: " + result.errorMessage);
                }
                if (result.hasResultset) {
                    if (queryBunch.selectedItemsCount >= 0 && queryBunch.selectedItemsCount != result.columns.size()) {
                        throw new Exception("Incorrect number of columns in the query result (may be caused by a custom aggregate containing a comma)");
                    }
                    metricsValues.putAll(this.getAggregates(result, computations));
                }
            }
        }
        finally {
            queryRuntime.close(false, false);
        }
        return metricsValues;
    }

    public static class HiveMetricsEngineConfig {
        public boolean active = true;
        public List<SimpleKeyValue> extraConf = Lists.newArrayList();
    }

    public static class SparkMetricsEngineConfig {
        public boolean active = true;
        public List<SimpleKeyValue> extraConf = Lists.newArrayList();
    }

    public static class ImpalaMetricsEngineConfig {
        public boolean active = true;
    }

    public static class SQLMetricsEngineConfig {
        public boolean active = true;
    }
}

