/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.metrics.probes.AdvancedStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.CellProbeType;
import com.dataiku.dip.metrics.probes.CheckProbeType;
import com.dataiku.dip.metrics.probes.ExternalProbeType;
import com.dataiku.dip.metrics.probes.ModelPerformanceProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.PercentileStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.metrics.probes.PythonProbeType;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.metrics.probes.ReportingProbeType;
import com.dataiku.dip.metrics.probes.SQLProbeType;
import com.dataiku.dip.metrics.probes.TemporaryMetricsProbeType;
import com.dataiku.dip.metrics.probes.VerifyDatasetColumnProbeType;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;

public class Probe {
    public final String type;
    public ProbeMetadata meta;
    public ComputeMode computeOnBuildMode = ComputeMode.NO;
    public boolean enabled = false;
    public ProbeConfiguration configuration;

    public Probe(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ProbeMetadata getMeta() {
        return this.meta;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ProbeConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T extends ProbeConfiguration> T getConfigurationAs(Class<T> clazz) {
        return (T)((ProbeConfiguration)clazz.cast(this.configuration));
    }

    public Probe withConfiguration(ProbeConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Probe withMeta(ProbeMetadata meta) {
        this.meta = meta;
        return this;
    }

    public Probe withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public static void registerJsonAdapters() {
        ProbeType.register(new BasicProbeType());
        ProbeType.register(new RecordsProbeType());
        ProbeType.register(new PartitioningProbeType());
        ProbeType.register(new ReportingProbeType());
        ProbeType.register(new ModelPerformanceProbeType());
        ProbeType.register(new BasicStatsDatasetProbeType());
        ProbeType.register(new AdvancedStatsDatasetProbeType());
        ProbeType.register(new PercentileStatsDatasetProbeType());
        ProbeType.register(new VerifyDatasetColumnProbeType());
        ProbeType.register(new PythonProbeType());
        ProbeType.register(new SQLProbeType());
        ProbeType.register(new CheckProbeType());
        ProbeType.register(new ExternalProbeType());
        ProbeType.register(new CellProbeType());
        ProbeType.register(new TemporaryMetricsProbeType());
        JSON.registerAdapter(Probe.class, (Object)new JSON.Adapter<Probe>(){

            public Probe deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonConfiguration;
                JsonElement jsonMetadata;
                JsonElement jsonComputeOnBuildmode;
                JsonObject jsonObj = json.getAsJsonObject();
                String probeTypeType = jsonObj.get("type").getAsString();
                Class<? extends ProbeConfiguration> paramsClass = ProbeType.getProbeParamsClazz(probeTypeType);
                if (paramsClass == null) {
                    if (probeTypeType.startsWith("sql_plugin") || probeTypeType.startsWith("py_plugin")) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown probe type : " + probeTypeType);
                    }
                    throw new IllegalArgumentException("Unknown probe type : " + probeTypeType);
                }
                Probe probe = new Probe(probeTypeType);
                JsonElement jsonEnabled = jsonObj.get("enabled");
                if (jsonEnabled != null) {
                    probe.enabled = jsonEnabled.getAsBoolean();
                }
                if ((jsonComputeOnBuildmode = jsonObj.get("computeOnBuildMode")) != null) {
                    probe.computeOnBuildMode = (ComputeMode)((Object)ctx.deserialize(jsonComputeOnBuildmode, ComputeMode.class));
                }
                if ((jsonMetadata = jsonObj.get("meta")) != null) {
                    probe = probe.withMeta((ProbeMetadata)ctx.deserialize(jsonMetadata, ProbeMetadata.class));
                }
                if ((jsonConfiguration = jsonObj.get("configuration")) != null) {
                    probe = probe.withConfiguration((ProbeConfiguration)ctx.deserialize(jsonObj.get("configuration"), paramsClass));
                } else {
                    try {
                        probe = probe.withConfiguration(paramsClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new JsonParseException("Failed to create empty configuration for type " + probeTypeType, (Throwable)e);
                    }
                }
                return probe;
            }

            public JsonElement serialize(Probe probe, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("type", probe.getType());
                jsonObj.add("enabled", ctx.serialize((Object)probe.isEnabled()));
                if (probe.computeOnBuildMode != null) {
                    jsonObj.addProperty("computeOnBuildMode", probe.computeOnBuildMode.name());
                }
                if (probe.getMeta() != null) {
                    jsonObj.add("meta", ctx.serialize((Object)probe.getMeta(), ProbeMetadata.class));
                }
                if (probe.getConfiguration() != null) {
                    jsonObj.add("configuration", ctx.serialize((Object)probe.getConfiguration()));
                }
                return jsonObj;
            }
        });
    }

    public static enum ComputeMode {
        NO,
        PARTITION,
        WHOLE_DATASET,
        BOTH;


        public boolean includesALL() {
            return this == WHOLE_DATASET || this == BOTH;
        }

        public boolean includesPartition() {
            return this == PARTITION || this == BOTH;
        }
    }
}

