/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pig;

import com.dataiku.dip.pig.PigProgressListener;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PigLogParser
implements DKUtils.LineSubscription {
    private static final Pattern pattern4j = Pattern.compile("^[0-9\\-]+\\s+[:0-9,]+\\s+(\\[[^\\]]+\\])?\\s+[A-Z]+\\s+[^\\-]+-\\s+");
    private static final Pattern errorLoc = Pattern.compile("<file\\s.*,\\sline ([0-9]+),\\scolumn\\s([0-9]+)>\\s");
    private static final Pattern progressPattern = Pattern.compile("^\\s*([0-9]+)%\\s*complete\\s*$");
    private static final String[] ignorePrefixes = new String[]{"Details at logfile", "Was expecting one of"};
    private final PigProgressListener listener;
    private String lastDetectedError = "";
    private boolean ignore = false;

    public PigLogParser(PigProgressListener listener) {
        this.listener = listener;
    }

    public void handle(String str, boolean replace) throws IOException {
        Matcher progressMatcher;
        str = pattern4j.matcher(str).replaceFirst("");
        str = errorLoc.matcher(str).replaceFirst("<line $1, column $2> ");
        for (String prefix : ignorePrefixes) {
            if (str.indexOf(prefix) != 0) continue;
            this.ignore = true;
        }
        if (!StringUtils.isBlank((String)str) && !this.ignore) {
            this.lastDetectedError = str;
        }
        if ((progressMatcher = progressPattern.matcher(str)).matches()) {
            int percentage = Integer.parseInt(progressMatcher.group(1));
            if (this.listener != null) {
                this.listener.progressChanged((double)percentage / 100.0);
            }
        }
    }

    public synchronized String getLastError() {
        return this.lastDetectedError;
    }

    public void close() throws IOException {
    }
}

