/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.AxesBinningModes;
import com.dataiku.dip.pivot.backend.common.automaticbin.BinningModeComputer;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModes;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModesIterator;
import com.dataiku.dip.pivot.backend.common.automaticbin.IAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.automaticbin.TimeInterval;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.SecurityAbortedException;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class AbstractAutomaticRequestHandler<TRequest extends PivotTableRequest>
implements IAutomaticRequestHandler {
    protected final TRequest request;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.automaticbin");

    protected AbstractAutomaticRequestHandler(TRequest request) {
        this.request = request;
    }

    abstract TimeInterval buildTimeInterval(AxisDef var1) throws IOException;

    abstract BinningModeComputer buildBinningModeComputer(int var1);

    @Override
    public void replaceAutomaticAggregationLevels() throws IOException {
        AxisDef[] axesDef = this.getAxesDef();
        for (ComputedBinningModes.AxisComputedBinningMode axisMode : this.highCardinalityAdaptiveComputedAutomaticBinningModes(null).axisModes()) {
            AxisDef automaticAxisToUpdate = axesDef[axisMode.getAxisIndex()];
            automaticAxisToUpdate.dateParams.mode = axisMode.getMode();
            logger.infoV("Automatic axis '%s' (index=%s) updated with computed mode '%s'", new Object[]{automaticAxisToUpdate.column, axisMode.getAxisIndex(), axisMode.getMode()});
        }
    }

    void logTimeInterval(AxisDef axisDef) {
        logger.debugV("Building timestamp interval for axis: '%s'", new Object[]{axisDef.column});
    }

    private ComputedBinningModes highCardinalityAdaptiveComputedAutomaticBinningModes(@Nullable ComputedBinningModesIterator computedBinningModesIterator) throws IOException {
        ComputedBinningModes result = this.computeAutomaticBinningModes(computedBinningModesIterator);
        try {
            this.checkComputedBinningModes(this.request, result);
            return result;
        }
        catch (SecurityAbortedException e) {
            logger.debugV("Too many drawable elements expected for the chart configuration and computed automatic date binning modes '%s'", new Object[]{result});
            if (result.getIterator().hasNext()) {
                logger.debug((Object)"New attempt with reduced cardinality on automatic date dimensions");
                return this.highCardinalityAdaptiveComputedAutomaticBinningModes(result.getIterator());
            }
            logger.warn((Object)"Could not find a valid chart configuration to reduce enough the drawable elements count");
            throw e;
        }
    }

    protected void checkComputedBinningModes(TRequest request, ComputedBinningModes result) throws SecurityAbortedException {
    }

    protected ComputedBinningModes computeAutomaticBinningModes(@Nullable ComputedBinningModesIterator computedBinningModesIterator) throws IOException {
        ComputedBinningModes result = new ComputedBinningModes();
        AxesBinningModes computedBinningMode = computedBinningModesIterator == null ? AxesBinningModes.defaultAxisBinningMode() : computedBinningModesIterator.next();
        AxisDef[] axesDef = this.getAxesDef();
        for (int axisIndex = 0; axisIndex < axesDef.length; ++axisIndex) {
            AxisDef axisDef = axesDef[axisIndex];
            if (!this.isAutomaticDateAxis(axisDef)) continue;
            logger.debugV("Automatic date axis found at index %s: '%s'", new Object[]{axisIndex, axisDef.column});
            result.add(axisIndex, this.buildBinningModeComputer(this.getMaxBinNumberForAutomaticMode(axisDef)).compute(this.buildTimeInterval(axisDef), computedBinningMode.getMode(axisIndex)));
        }
        result.setOrCreateIterator(computedBinningModesIterator);
        return result;
    }

    protected abstract AxisDef[] getAxesDef();

    private int getMaxBinNumberForAutomaticMode(AxisDef axisDef) {
        return axisDef.dateParams.maxBinNumberForAutomaticMode;
    }

    private boolean isAutomaticDateAxis(AxisDef axisDef) {
        return AxisDef.Type.DATE.equals((Object)axisDef.type) && DateAxisParams.BinningMode.AUTOMATIC.equals((Object)axisDef.dateParams.mode);
    }
}

