/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.NumericLabelGroupedBinner;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeFieldType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class QuarterOfYearGroupedBinner
extends NumericLabelGroupedBinner {
    private static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    @Override
    DateTimeFieldType timeField() {
        return DateTimeFieldType.monthOfYear();
    }

    @Override
    int offset() {
        return 1;
    }

    @Override
    public long getBinId(long timestamp) {
        return (this.getUnitValue(timestamp) - 1L) / (long)this.numberOfElementInUnit();
    }

    @Override
    public int getFixedNbBins() {
        return 4;
    }

    @Override
    DatePart datePart() {
        return DatePart.MONTH_OF_YEAR;
    }

    @Override
    String buildExpression(String input, SQLDialect dialect) {
        return EBF.expr(super.buildExpression(input, dialect) + String.format("/%s", DECIMAL_FORMATTER.format(this.numberOfElementInUnit()))).ceil().toSQL(dialect);
    }

    private int numberOfElementInUnit() {
        return 3;
    }
}

