/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableUtils;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;

public class NumericalFixedSizeBinsAxisHandler
implements AxisHandler {
    private Column col;
    private NumericalAxisParams params;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double fixedMin;
    private double fixedMax;
    private int nbBins;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.pivot");

    public NumericalFixedSizeBinsAxisHandler(Column col, NumericalAxisParams params) {
        this.col = col;
        this.params = params;
    }

    @Override
    public void observe(Row row) {
        double val = Double.NaN;
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            val = Double.parseDouble(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Double.isNaN(val) && !Double.isInfinite(val)) {
            this.min = Math.min(this.min, val);
            this.max = Math.max(this.max, val);
        }
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            double d;
            if (filters != null && !filters[i] || Double.isNaN(d = block.doubles[i]) || Double.isInfinite(d)) continue;
            this.min = Math.min(this.min, d);
            this.max = Math.max(this.max, d);
        }
    }

    @Override
    public int getNbBins() {
        if (Double.isInfinite(this.min) || Double.isInfinite(this.max)) {
            return 1;
        }
        this.fixedMin = Math.floor(this.min / this.params.binSize) * this.params.binSize;
        this.fixedMax = Math.ceil(this.max / this.params.binSize) * this.params.binSize;
        this.nbBins = (int)((this.fixedMax - this.fixedMin) / this.params.binSize) + 1;
        logger.infoV("min=%f max=%f fixedMin=%f fixedMax=%f nbBins=%d", new Object[]{this.min, this.max, this.fixedMin, this.fixedMax, this.nbBins});
        return this.nbBins;
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (filters != null && !filters[i]) {
                ret[i] = 0;
                continue;
            }
            double v = block.doubles[i];
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                ret[i] = -1;
                continue;
            }
            double scaled = Math.floor(v / this.params.binSize) * this.params.binSize;
            ret[i] = (int)((scaled - this.fixedMin) / this.params.binSize);
        }
    }

    @Override
    public List<AxisElt> getAxisElts() {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        for (int i = 0; i < this.nbBins; ++i) {
            double low = this.fixedMin + this.params.binSize * (double)i;
            double high = this.fixedMin + this.params.binSize * (double)(i + 1);
            NumericalAxisElt elt = new NumericalAxisElt();
            elt.sortValue = this.fixedMin + this.params.binSize * ((double)i + 0.5);
            elt.min = low;
            elt.max = high;
            elt.label = PivotTableUtils.formatDoubleForStep(low, this.params.binSize) + "-" + PivotTableUtils.formatDoubleForStep(high, this.params.binSize);
            ret.add(elt);
        }
        return ret;
    }
}

