/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class PivotTableUtils {
    private static DateTimeFormatter YMD_FORMAT = ISODateTimeFormat.yearMonthDay();
    private static DateTimeFormatter YMDHMS_FORMAT = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearMonthDay()).appendLiteral(' ').append(ISODateTimeFormat.hourMinuteSecond()).toFormatter();
    private static DateTimeFormatter YMDHMSF_FORMAT = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearMonthDay()).appendLiteral(' ').append(ISODateTimeFormat.hourMinuteSecondMillis()).toFormatter();

    public static String formatDouble(double x) {
        double decimal = x % 1.0;
        Object s = "";
        s = decimal == 0.0 ? (String)s + (long)x : (String)s + x;
        return s;
    }

    public static String formatTemporal(double x, Type type) {
        if (type == Type.DATEONLY) {
            return YMD_FORMAT.print((long)x);
        }
        if (type == Type.DATETIMENOTZ || type == Type.DATE) {
            long l = (long)x;
            if (l % 1000L != 0L) {
                return YMDHMSF_FORMAT.print((long)x);
            }
            return YMDHMS_FORMAT.print((long)x);
        }
        return PivotTableUtils.formatDouble(x);
    }

    static int getDecimalPlaces(double in) {
        int i = 0;
        double d;
        while ((double)Math.round(d = in * Math.pow(10.0, i)) != d) {
            ++i;
        }
        return i;
    }

    public static String formatDoubleForStep(double x, double step) {
        double decimalPart = x % 1.0;
        if (decimalPart == 0.0) {
            return "" + (long)x;
        }
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        if (step > 1.0) {
            df.setMaximumFractionDigits(1);
        } else {
            int decimalPlacesOfStep = PivotTableUtils.getDecimalPlaces(step);
            df.setMaximumFractionDigits(decimalPlacesOfStep);
        }
        return df.format(x);
    }

    private PivotTableUtils() {
    }

    public static class NumberFormatter {
        final int minDecimals;
        final String coma;

        public NumberFormatter(Double minValue, Double maxValue, int numValues, boolean comaSeparated) {
            double minPrecision;
            int maxNumberOfDecimals = 11;
            this.minDecimals = maxValue - minValue < 1.0E-10 ? (int)Math.min(11.0, Math.max(0.0, Math.ceil(Math.log10(Math.abs(maxValue))))) : ((minPrecision = (maxValue - minValue) / (double)numValues) == 0.0 ? 0 : (int)Math.min(11.0, Math.max(0.0, Math.ceil(-Math.log10(minPrecision)))));
            this.coma = comaSeparated ? "," : "";
        }

        public NumberFormatter(Double minValue, Double maxValue, int numValues) {
            this(minValue, maxValue, numValues, false);
        }

        public String format(Double x) {
            double abs = Math.abs(x);
            String defaultFormat = String.format(Locale.US, "%" + this.coma + "." + this.minDecimals + "f", x);
            if (abs == 0.0) {
                return "0";
            }
            if (abs < 1.0E-5) {
                int numDigits = (int)Math.max(0.0, (double)this.minDecimals - Math.floor(-Math.log10(x)) - 1.0);
                String format = this.minDecimals > 1 ? "0." + StringUtils.repeat((String)"0", (int)numDigits) + "E0" : "0E0";
                return new DecimalFormat(format, DecimalFormatSymbols.getInstance(Locale.US)).format(x).toLowerCase();
            }
            if (this.minDecimals > 0) {
                return defaultFormat;
            }
            if (abs >= 10000.0) {
                return NumberFormatter.formatWithDecimalPrefix(x);
            }
            return defaultFormat;
        }

        public static String formatWithDecimalPrefix(Double x) {
            boolean negative;
            boolean bl = negative = x < 0.0;
            if (negative) {
                x = -x.doubleValue();
            }
            String prefixes = "kMGTPEZYRQ";
            int exp = (int)Math.floor(Math.log10(x) / 3.0);
            double value = x / Math.pow(1000.0, exp);
            String format = (negative ? "-" : "") + "%.1f%s";
            if (value >= 10.0) {
                format = (negative ? "-" : "") + "%.0f%s";
            }
            return String.format(Locale.US, format, value, exp <= prefixes.length() ? Character.valueOf(prefixes.charAt(exp - 1)) : "e+" + exp * 3);
        }
    }
}

