/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.DoubleDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import java.io.IOException;

public abstract class DoubleAggregator
extends AbstractAggregator<Double> {
    private final String errorMessage;

    protected DoubleAggregator(Aggregation req, int[] numBins, String errorMessage) {
        super(req, new DoubleDataTensor.Builder().axisLengths(numBins).initNonNullCounts(true).build());
        this.errorMessage = errorMessage;
    }

    protected DoubleAggregator(Aggregation req, int bins, String errorMessage) {
        super(req, new DoubleDataTensor.Builder().axisLengths(bins).initNonNullCounts(true).build());
        this.errorMessage = errorMessage;
    }

    protected DoubleAggregator(Aggregation req, String errorMessage) {
        super(req, new DoubleDataTensor.Builder().axisLengths(1).initNonNullCounts(true).build());
        this.errorMessage = errorMessage;
    }

    @Override
    public void handleBlock(ColumnBlock column, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        if (column.getMemoryType() != ColumnBlock.MemoryType.DOUBLE) {
            throw new IOException(this.errorMessage);
        }
        this.getOutDT().type = column.realType == Type.DATE ? TensorType.DATE : TensorType.NUMERICAL;
        super.handleBlock(column, start, rows, coords, bins, filters, fillAxes);
    }

    @Override
    protected void handle(Object value, int[] coords) throws IOException {
        throw new IOException(this.errorMessage);
    }

    @Override
    public DataTensor<Double> mergeTensor() {
        for (int i = 0; i < this.getOutDT().tensorSize; ++i) {
            this.getMergeDT().setAsDouble(i, this.getDoubleValue(i, this.getOutDT().nonNullCounts));
        }
        this.getMergeDT().nonNullCounts = this.getOutDT().nonNullCounts;
        return this.getMergeDT();
    }

    @Override
    public Double mergeValues(Double v1, Double v2) {
        return Double.sum(v1, v2);
    }

    @Override
    public int compareValues(Double v1, Double v2) {
        return Double.compare(v2, v1);
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        double value = this.getOutDT().getAsDouble(origCoordinates);
        for (int i = 0; i < axes.length; ++i) {
            if (targetCoordinates[i] != axes[i].nbNotCutoff) continue;
            if (!request.axes[i].sortPrune.generateOthersCategory) {
                return false;
            }
            this.getMergeDT().setAxisAsDouble(i, targetCoordinates[i], this.mergeDoubleValues(this.getMergeDT().getAxisAsDouble(i, targetCoordinates[i]), value));
        }
        this.getMergeDT().setAsDouble(targetCoordinates, this.mergeDoubleValues(this.getMergeDT().getAsDouble(targetCoordinates), value));
        if (this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }

    @Override
    public void applyOtherCategoryToTensor(AbstractAggregator.OtherCategoryProperties<Double> ocp, int index) {
        this.getMergeDT().setAsDouble(index, (double)((Double)ocp.aggrOfOthersColumn));
    }

    @Override
    protected void transferBinToMergeDT(int originBin, int targetBin, LongDataList countList) {
        this.getMergeDT().setAsDouble(targetBin, this.getDoubleValue(originBin, countList));
    }

    @Override
    protected void transferBinToAxisMergeDT(int i, int j, int jTargetBin) {
        this.getMergeDT().setAxisAsDouble(i, jTargetBin, this.getDoubleValue(this.getOutDT().getAxisAsDouble(i, j), this.getAxisNonNullCount(i, j)));
    }

    @Override
    public void mapFillMergeDT(LongDataList countList) {
        DoubleDataTensor mergeDTd = (DoubleDataTensor)this.getMergeDT();
        for (int i = 0; i < this.getOutDT().tensorSize; ++i) {
            double value = this.getDoubleValue(i, countList);
            mergeDTd.setAsDouble(i, value);
            mergeDTd.min = Math.min(mergeDTd.min, value);
            mergeDTd.max = Math.max(mergeDTd.max, value);
        }
        mergeDTd.nonNullCounts = this.getOutDT().nonNullCounts;
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<Double> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        AbstractAggregator.OtherCategoryProperties<Double> otherCategoryProperties = new AbstractAggregator.OtherCategoryProperties<Double>();
        double otherValue = 0.0;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (!axis.elts.get((int)x).cutoffed) continue;
            int origBin = axis.elts.get((int)x).binIndex;
            otherValue += this.getOutDT().getAsDouble(origBin);
            otherCategoryProperties.nonNullCountOfOthersColumn += this.getOutDT().nonNullCounts[origBin];
        }
        otherCategoryProperties.aggrOfOthersColumn = this.getDoubleValue(otherValue, otherCategoryProperties.nonNullCountOfOthersColumn);
        return otherCategoryProperties;
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, LongDataList countList) {
        ret.elts.sort((o1, o2) -> {
            double v1 = this.getDoubleValue(o1.binIndex, countList);
            double v2 = this.getDoubleValue(o2.binIndex, countList);
            return this.compare(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, this.getOutDT().nonNullCounts);
        });
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, int axisIdx) {
        long[] nnc = this.getOutDT().axesNonNullCounts[axisIdx];
        ret.elts.sort((o1, o2) -> {
            double v1 = this.getDoubleValue(this.getOutDT().getAxisAsDouble(axisIdx, o1.binIndex), nnc[o1.binIndex]);
            double v2 = this.getDoubleValue(this.getOutDT().getAxisAsDouble(axisIdx, o2.binIndex), nnc[o2.binIndex]);
            return this.compare(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, nnc);
        });
    }

    protected int compare(double v1, double v2, AxisElt o1, AxisElt o2, int asc, long[] nnc) {
        return this.compare(v1, v2, o1, o2, asc, nnc, 0);
    }

    protected int compare(double v1, double v2, AxisElt o1, AxisElt o2, int asc, long[] nnc, int invalidCountValue) {
        double nnc1 = nnc[o1.binIndex];
        double nnc2 = nnc[o2.binIndex];
        if (nnc1 <= (double)invalidCountValue || nnc2 <= (double)invalidCountValue) {
            if (nnc1 == nnc2) {
                return 0;
            }
            if (nnc1 <= (double)invalidCountValue) {
                return 1;
            }
            return -1;
        }
        return asc * Double.compare(v2, v1);
    }
}

