/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DoubleDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.DoubleAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregatorImpl;
import com.dataiku.dip.pivot.backend.dss.aggregators.MergeVisitor;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import java.io.IOException;
import java.util.ArrayList;

public abstract class FlushableAggregatorWrapper<T, U>
extends DoubleAggregator {
    private static final String ERROR_MESSAGE = "";
    private final FlushableAggregatorImpl<T, U> aggregator;
    private final FlushableAggregatorImpl<T, U>[] axes;
    private FlushableAggregatorImpl<T, U> mergeAggregator;
    private FlushableAggregatorImpl<T, U>[] mergeAxes;

    public FlushableAggregatorWrapper(Aggregation req) {
        this(req, 1);
    }

    public FlushableAggregatorWrapper(Aggregation req, int[] numBins) {
        super(req, numBins, ERROR_MESSAGE);
        this.aggregator = this.newFlushableInstance(this.getOutDT().getDoubleTensor(), this.getOutDT().nonNullCounts, req.column);
        this.axes = this.newFlushableArrayInstance(this.getOutDT().getAxesLength());
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i] = this.newFlushableInstance(this.getOutDT().getDoubleAxes()[i], null, req.column + "_axis_" + i);
        }
    }

    public FlushableAggregatorWrapper(Aggregation aggregation, int bins) {
        super(aggregation, bins, ERROR_MESSAGE);
        this.axes = this.newFlushableArrayInstance(0);
        this.aggregator = this.newFlushableInstance(this.getOutDT().getDoubleTensor(), this.getOutDT().nonNullCounts, this.req.column);
    }

    public abstract FlushableAggregatorImpl<T, U> newFlushableInstance(double[] var1, long[] var2, String var3);

    public abstract FlushableAggregatorImpl<T, U>[] newFlushableArrayInstance(int var1);

    public abstract MergeVisitor<T, U> getMergeVisitor(FlushableAggregatorImpl<T, U> var1, int var2);

    @Override
    public void handleBlock(ColumnBlock aggrColumn, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            if (filters != null && !filters[row]) continue;
            int[] destBin = this.extractDestBin(row, coords, bins);
            if (destBin != null) {
                if (aggrColumn.doubles != null) {
                    this.handle(aggrColumn.doubles[row], destBin, fillAxes);
                } else {
                    this.handle(aggrColumn.getAsStringSlow(row), destBin, fillAxes);
                }
                if (fillAxes) {
                    this.getOutDT().incrementAxesNonNullCount(destBin);
                }
            }
            this.getOutDT().hasNullValues = this.aggregator.hasNullValues;
        }
    }

    @Override
    protected void handle(double value, int[] coords, boolean fillAxes) throws IOException {
        this.aggregator.handle(value, this.getOutDT().loc(coords));
        for (int i = 0; fillAxes && i < this.axes.length; ++i) {
            this.axes[i].handle(value, coords[i]);
        }
    }

    @Override
    protected void handle(Object value, int[] coords, boolean fillAxes) throws IOException {
        this.aggregator.handle(value, this.getOutDT().loc(coords));
        for (int i = 0; fillAxes && i < this.axes.length; ++i) {
            this.axes[i].handle(value, coords[i]);
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.aggregator.onEnd();
        for (FlushableAggregatorImpl<T, U> axe : this.axes) {
            axe.onEnd();
        }
        ((DoubleDataTensor)this.getOutDT()).tensor = this.aggregator.data;
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
        for (FlushableAggregatorImpl<T, U> axesDistinctCount : this.axes) {
            axesDistinctCount.close();
        }
        if (this.mergeAggregator != null) {
            this.mergeAggregator.close();
            for (FlushableAggregatorImpl<T, U> mergeAxisDistinctCount : this.mergeAxes) {
                if (mergeAxisDistinctCount == null) continue;
                mergeAxisDistinctCount.close();
            }
        }
    }

    @Override
    public void initMerge() {
        this.setMergeDT(this.getOutDT().createMergeDT(this.getOutDT().axisLengths, this.aggregator.hasNullValues));
    }

    @Override
    public void mergeEnd(AxisHandler.Axis[] axes, LongDataTensor countTensor) throws IOException {
        if (this.mergeAggregator == null) {
            return;
        }
        this.mergeAggregator.onEnd(false);
        for (FlushableAggregatorImpl<T, U> mergeAxesDistinctCount : this.mergeAxes) {
            if (mergeAxesDistinctCount == null) continue;
            mergeAxesDistinctCount.onEnd(false);
        }
        super.mergeEnd(axes, countTensor);
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<Double> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        AbstractAggregator.OtherCategoryProperties<Double> otherCategoryProperties = new AbstractAggregator.OtherCategoryProperties<Double>();
        if (axis.nbNotCutoff == this.getOutDT().nonNullCounts.length) {
            otherCategoryProperties.aggrOfOthersColumn = 0.0;
            return otherCategoryProperties;
        }
        double[] otherData = new double[this.getOutDT().nonNullCounts.length];
        try (FlushableAggregatorImpl<T, U> mergeAggregator = this.newFlushableInstance(otherData, this.getOutDT().nonNullCounts, "merge_" + this.req.column);){
            for (int x = 0; x < axis.elts.size(); ++x) {
                if (!axis.elts.get((int)x).cutoffed) continue;
                int origBin = axis.elts.get((int)x).binIndex;
                this.aggregator.readValues(origBin, this.getMergeVisitor(mergeAggregator, axis.nbNotCutoff));
                otherCategoryProperties.nonNullCountOfOthersColumn += this.getOutDT().nonNullCounts[origBin];
            }
            mergeAggregator.onEnd(false);
            otherCategoryProperties.aggrOfOthersColumn = mergeAggregator.data[axis.nbNotCutoff];
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred", (Throwable)e);
        }
        return otherCategoryProperties;
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        if (this.mergeAggregator == null) {
            this.mergeAggregator = this.newFlushableInstance(this.getMergeDT().getDoubleTensor(), this.getMergeDT().nonNullCounts, "merge_" + this.req.column);
            this.mergeAxes = this.newFlushableArrayInstance(axes.length);
        }
        ArrayList<FlushableAggregator.Visitor> visitors = new ArrayList<FlushableAggregator.Visitor>();
        for (int i = 0; i < axes.length; ++i) {
            if (targetCoordinates[i] != axes[i].nbNotCutoff) continue;
            if (!request.axes[i].sortPrune.generateOthersCategory) {
                return false;
            }
            if (this.mergeAxes[i] == null) {
                this.mergeAxes[i] = this.newFlushableInstance(this.getMergeDT().getAxisAsDouble(i), null, "merge_" + this.req.column + "_axis_" + i);
            }
            visitors.add(this.getMergeVisitor(this.mergeAxes[i], targetCoordinates[i]));
        }
        int destLoc = this.getMergeDT().loc(targetCoordinates);
        visitors.add(this.getMergeVisitor(this.mergeAggregator, destLoc));
        this.aggregator.readValues(this.getOutDT().loc(origCoordinates), new FlushableAggregator.VisitorManager(visitors));
        if (this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }
}

