/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.LinoAxisHandler;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.maps.LinoPointAdminAxisHandler;
import com.dataiku.dip.pivot.backend.dss.maps.PivotMapAggrBuilderBase;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrAdminRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrResponse;
import com.dataiku.dip.shaker.processors.geo.GeoJSONUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;

public class PivotMapAdminAggrBuilder
extends PivotMapAggrBuilderBase {
    private final PTMapAggrAdminRequest request;
    private static final Cache<String, JSONObject> geoJsonCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public PivotMapAdminAggrBuilder(PTMapAggrAdminRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PTMapAggrResponse buildFromLino(LinoReader linoReader, VariablesContext variablesContext) throws Exception {
        this.buildLinoFilters(this.request, linoReader);
        String lonName = this.request.geoColumn + "__dku_lon";
        LinoPointAdminAxisHandler lpa = new LinoPointAdminAxisHandler(lonName, this.request.geoColumn + "__dku_lat", this.request);
        for (int block = 0; block < linoReader.nblocks(); ++block) {
            ColumnBlock lonBlock = linoReader.readColumnBlock(lonName, block);
            boolean[] filters = null;
            if (this.filtered) {
                filters = new boolean[lonBlock.nbRecords()];
                this.filterLinoBlock(this.request, linoReader, block, filters);
            }
            lpa.observe(linoReader, block, filters);
        }
        int bins = lpa.getNbBins();
        logger.info((Object)("End of binning pass, bins=" + bins));
        BinsAndTensorsSafetyChecks.failIfTooManyBinsOnSingleAxis(null, bins);
        this.buildAggregationStructures(bins, this.request, variablesContext, linoReader);
        for (int block = 0; block < linoReader.nblocks(); ++block) {
            this.addLinoPass2(linoReader, block, lpa);
        }
        return this.end(lpa);
    }

    private void addLinoPass2(LinoReader linoReader, int blockIdx, LinoAxisHandler handler) throws IOException {
        String lonName = this.request.geoColumn + "__dku_lon";
        this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
        ColumnBlock lonBlock = linoReader.readColumnBlock(lonName, blockIdx);
        boolean[] filters = this.handleFiltersAndCounts(this.request, lonBlock, linoReader, blockIdx);
        int[] bins = new int[lonBlock.nbRecords()];
        handler.getBins(linoReader, blockIdx, bins, filters);
        this.updateAggregations(this.request, bins, filters, PivotTableAggrBuilder.getAggrBlocks(linoReader, this.request.aggregations, blockIdx), linoReader, blockIdx);
    }

    private PTMapAggrResponse end(LinoPointAdminAxisHandler lpa) throws JSONException, ExecutionException, IOException {
        logger.info((Object)"End of accumulation phase");
        PTMapAggrResponse resp = new PTMapAggrResponse();
        resp.engine = PivotTableResponse.PivotEngine.LINO;
        for (int aggrId = 0; aggrId < this.request.aggregations.size(); ++aggrId) {
            AbstractAggregator aggregator = (AbstractAggregator)this.aggregators.get(aggrId);
            aggregator.end();
        }
        List<LinoPointAdminAxisHandler.GeoAxisElt> elts = lpa.getGeoAxisElts();
        PostPruneSafetyChecks.checkSimple(elts.size(), DKUApp.getParams().getIntParam("dku.charts.maps.admin.maxDrawnFeatures", Integer.valueOf(50000)));
        JSONObject fc = new JSONObject();
        fc.put("type", (Object)"FeatureCollection");
        JSONArray features = new JSONArray();
        fc.put("features", (Object)features);
        for (LinoPointAdminAxisHandler.GeoAxisElt elt : elts) {
            JSONObject feature = new JSONObject();
            feature.put("type", (Object)"Feature");
            if (this.request.filled) {
                String key = this.request.adminLevel + "-" + elt.dataIndex;
                JSONObject geoJSON = (JSONObject)geoJsonCache.get((Object)key, () -> new JSONObject(GeoJSONUtils.getGeoJSON(elt.geom)));
                feature.put("geometry", (Object)geoJSON);
            } else {
                feature.put("geometry", (Object)new JSONObject(GeoJSONUtils.getGeoJSON((Geometry)elt.centroid)));
            }
            JSONObject props = new JSONObject();
            feature.put("properties", (Object)props);
            for (int aggrIdx = 0; aggrIdx < this.aggregators.size(); ++aggrIdx) {
                AbstractAggregator aggr = (AbstractAggregator)this.aggregators.get(aggrIdx);
                double value = aggr.getDoubleValue(elt.binIndex, this.countList);
                String aggrReqId = aggr.req.id;
                if (aggrReqId != null) {
                    if (("color".equals(aggrReqId) || "size".equals(aggrReqId)) && (Double.isInfinite(value) || Double.isNaN(value))) continue;
                    props.put(aggrReqId, value);
                    continue;
                }
                props.put("a_" + aggrIdx, value);
            }
            props.put("binIndex", elt.binIndex);
            props.put("dataIndex", elt.dataIndex);
            props.put("label", (Object)elt.label);
            props.put("count", this.countList.data[elt.binIndex]);
            features.put((Object)feature);
        }
        logger.info((Object)("After, cache stats: " + JSON.json((Object)geoJsonCache.stats())));
        resp.geoJson = fc.toString();
        lpa.fillBounds(resp);
        logger.info((Object)"Build filters");
        this.computeFilterFacets(this.request, resp);
        logger.info((Object)"End of building output data");
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        return resp;
    }
}

