/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableFiltersRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableFiltersResponse;
import com.dataiku.dip.pivot.backend.sql.SQLPivotListener;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.cache.CacheContext;
import com.dataiku.dip.pivot.backend.sql.executors.BasicStatsHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.ColumnMappingHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.FacetsHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.GlobalStatsHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.executors.MainPivotHybridExecutor;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SQLPivotExecutor {
    private CacheContext cache;
    private static Logger logger = Logger.getLogger(SQLPivotExecutor.class);

    public SQLPivotExecutor(CacheContext cache) {
        this.cache = cache;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PivotTableResponse computePivotTableResponse(InputTable input, PivotTableAggregatedRequest req, SQLPivotListener listener, AuthCtx authCtx) throws Exception {
        if (!SQLPivotExecutor.canHandleInput(input)) {
            throw new UnsupportedOperation("Cannot use in-database engine: this database is incompatible. Please switch engine.");
        }
        if (!SQLPivotExecutor.canHandlePivotRequest(req)) {
            throw new UnsupportedOperation("Cannot use in-database engine: unsupported request kind. Please switch engine.");
        }
        try (ExecutionContext ctx = new ExecutionContext(this.cache, input, req, listener, authCtx);){
            PivotTableResponse pivotTableResponse;
            block21: {
                FutureAborter.AutoCloseableAbortHook aborting;
                block19: {
                    PivotTableFiltersResponse pivotTableFiltersResponse;
                    block20: {
                        aborting = FutureAborter.pushAutoCloseableHook(() -> {
                            logger.info((Object)"Stop pivot computation threads");
                            ctx.cancel();
                        });
                        try {
                            if (!(req instanceof PivotTableFiltersRequest)) break block19;
                            pivotTableFiltersResponse = SQLPivotExecutor.computePivotTableFiltersRequest(ctx);
                            if (aborting == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (aborting != null) {
                                try {
                                    aborting.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        aborting.close();
                    }
                    return pivotTableFiltersResponse;
                }
                pivotTableResponse = SQLPivotExecutor.computePivotTableTensorRequest(ctx);
                if (aborting == null) break block21;
                aborting.close();
            }
            return pivotTableResponse;
        }
        catch (ExecutionException e) {
            logger.error((Object)"Error when executing SQL chart", (Throwable)e);
            Throwable t = e;
            while (t instanceof ExecutionException) {
                t = t.getCause();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    public static boolean canHandleInput(InputTable input) {
        if (input != null) {
            SQLDialect dialect = input.dialect;
            return dialect.supportsInDatabaseCharts();
        }
        return false;
    }

    public static boolean canHandleInput(DSSConnection connection, SQLDialect dialect) {
        if (connection instanceof AbstractSQLConnection) {
            return ((AbstractSQLConnection)connection).getDialect().supportsInDatabaseCharts();
        }
        return dialect != null && dialect.supportsInDatabaseCharts();
    }

    public static boolean canHandlePivotRequest(PivotTableRequest req) {
        if (req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)req;
            return !treq.hexbin;
        }
        return req instanceof PivotTableFiltersRequest || req instanceof SimpleAggregatedRequest;
    }

    private static PivotTableResponse computePivotTableTensorRequest(ExecutionContext ctx) throws ExecutionException, InterruptedException {
        Future<ColumnMapper> colMappingFuture = ctx.threadPool.submit(new ColumnMappingHybridExecutor(ctx));
        Future<BasicStatsBuilder.BasicStats> globalStatsFuture = ctx.threadPool.submit(new GlobalStatsHybridExecutor(ctx, colMappingFuture));
        Future<BasicStatsBuilder.BasicStats> basicStatsFuture = ctx.threadPool.submit(new BasicStatsHybridExecutor(ctx, colMappingFuture, globalStatsFuture));
        Future<List<FilterFacet>> filterFacetsFuture = ctx.threadPool.submit(new FacetsHybridExecutor(ctx, colMappingFuture, basicStatsFuture, globalStatsFuture));
        Future<PivotTableResponse> mainPivotFuture = ctx.threadPool.submit(new MainPivotHybridExecutor(ctx, colMappingFuture, basicStatsFuture, globalStatsFuture));
        PivotTableResponse response = mainPivotFuture.get();
        List<FilterFacet> filterFacets = filterFacetsFuture.get();
        BasicStatsBuilder.BasicStats stats = basicStatsFuture.get();
        logger.debug((Object)"All subtasks complete");
        response.setRecordCounts(stats.totalBeforeFiltering, stats.totalAfterFiltering);
        response.filterFacets = filterFacets;
        response.engine = PivotTableResponse.PivotEngine.SQL;
        return response;
    }

    private static PivotTableFiltersResponse computePivotTableFiltersRequest(ExecutionContext ctx) throws ExecutionException, InterruptedException {
        Future<ColumnMapper> colMappingFuture = ctx.threadPool.submit(new ColumnMappingHybridExecutor(ctx));
        Future<BasicStatsBuilder.BasicStats> globalStatsFuture = ctx.threadPool.submit(new GlobalStatsHybridExecutor(ctx, colMappingFuture));
        Future<BasicStatsBuilder.BasicStats> basicStatsFuture = ctx.threadPool.submit(new BasicStatsHybridExecutor(ctx, colMappingFuture, globalStatsFuture));
        Future<List<FilterFacet>> filterFacetsFuture = ctx.threadPool.submit(new FacetsHybridExecutor(ctx, colMappingFuture, basicStatsFuture, globalStatsFuture));
        List<FilterFacet> filterFacets = filterFacetsFuture.get();
        logger.debug((Object)"All subtasks complete");
        PivotTableFiltersResponse response = new PivotTableFiltersResponse();
        response.filterFacets = filterFacets;
        response.engine = PivotTableResponse.PivotEngine.SQL;
        return response;
    }
}

