/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.binners;

import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.backend.sql.binners.DoubleAxisBinner;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UnbinnedNumericalAxisBinner
implements DoubleAxisBinner {
    private HashMap<Double, Integer> map = new HashMap();
    private List<AxisElt> elts = new ArrayList<AxisElt>();
    private AxisElt otherBin;
    private NumericalAxisElt allBin;

    public UnbinnedNumericalAxisBinner(NullableDoubleArrayList values, boolean createOthers, boolean createAllBin) {
        int currentBinIndex = 0;
        for (int i = 0; i < values.size(); ++i) {
            Double val = values.getNullable(i);
            if (val == null) continue;
            this.map.put(val, currentBinIndex);
            NumericalAxisElt elt = new NumericalAxisElt();
            elt.binIndex = currentBinIndex++;
            elt.max = val;
            elt.sortValue = val;
            elt.min = val;
            elt.label = "" + val;
            this.elts.add(elt);
        }
        if (createOthers) {
            this.otherBin = new AxisElt();
            this.otherBin.binIndex = this.elts.size();
            this.otherBin.label = "___dku_others_value___";
            this.map.put(null, this.elts.size());
            this.elts.add(this.otherBin);
        }
        if (createAllBin) {
            this.allBin = new NumericalAxisElt();
            this.allBin.max = Double.MAX_VALUE;
            this.allBin.min = Double.MIN_VALUE;
            this.allBin.sortValue = Double.MAX_VALUE;
            this.allBin.binIndex = this.elts.size();
            this.allBin.label = "___dku_total_value___";
            this.map.put(null, this.elts.size());
            this.elts.add(this.allBin);
        }
    }

    @Override
    public int assign(Double val) {
        return this.map.get(val);
    }

    @Override
    public AxisElt getOtherBin() {
        return this.otherBin;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        return this.elts;
    }
}

