/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.cli.PluginInstaller;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.cde.CDEImageBuilderService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginExtraInfo;
import com.dataiku.dip.plugins.PluginSettingsAccessService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.InstalledPluginState;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.model.StorePluginsList;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.DSSUpdateServiceUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.PagesSettingsForceIndexAllEvent;
import com.dataiku.dip.server.notifications.backend.PluginChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.RepeatingListFetcher;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginStoreService
extends RepeatingListFetcher<StorePluginsList> {
    public static final String DKU_PLUGINS_EXCLUDES_CONFIG = "dku.plugins.excludes";
    @Autowired
    IPermissionsService permissionsService;
    @Autowired
    private PluginsLoadService loadService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private PluginSettingsAccessService pluginSettingsAccessService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeCodeEnvsService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeCodeEnvsService;
    @Autowired
    private RequestsService requestService;
    @Autowired
    private CDEImageBuilderService cdeImageBuilderService;
    private boolean pluginConfigurationIsDirty = false;
    private static final Logger logger = Logger.getLogger((String)"dku.pluginstore");

    public PluginStoreService() {
        super(DSSUpdateServiceUtils.getPluginsListURL(), logger, StorePluginsList.class);
    }

    public PluginsStateList getStateList(DSSAuthCtx liu) {
        return this.getStateList(liu, true);
    }

    public PluginsStateList getStateListNoCheck() {
        return this.getStateList(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchNow(Map<String, String> specialHeaders) {
        SerializedError localFetchException;
        super.fetchNow(specialHeaders);
        PluginStoreService pluginStoreService = this;
        synchronized (pluginStoreService) {
            localFetchException = this.fetchException;
        }
        if (localFetchException != null) {
            StorePluginsList localFetchedList;
            try {
                localFetchedList = (StorePluginsList)JSON.parseFile((File)DKUApp.getResourceFile((String)"plugins-list.json"), StorePluginsList.class);
                this.filterListItems(localFetchedList);
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot parse plugins configuration", (Throwable)e);
                localFetchedList = null;
            }
            pluginStoreService = this;
            synchronized (pluginStoreService) {
                this.fetchedList = localFetchedList;
            }
        }
        this.pubSub.publish((DSSEvent)new PagesSettingsForceIndexAllEvent());
    }

    @Override
    public void filterListItems(StorePluginsList fetchedList) {
        String excludes = DKUApp.getProperty((String)DKU_PLUGINS_EXCLUDES_CONFIG, null);
        if (StringUtils.isBlank((String)excludes)) {
            return;
        }
        PluginStoreService.filterList(fetchedList, excludes);
    }

    private static void filterList(StorePluginsList fetchedList, String excludes) {
        Set<String> names = Set.of(excludes.split(","));
        List filtered = fetchedList.items.stream().filter(item -> {
            if (item == null || item.id == null) {
                return true;
            }
            return !names.contains(item.id);
        }).collect(Collectors.toList());
        fetchedList.items = filtered;
    }

    public void forceFetch(AuthCtx authCtx) {
        this.fetchNow(this.settingsService.getCustomHeadersForTracking(authCtx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginsStateList getStateList(DSSAuthCtx liu, boolean checkPermissions) {
        StorePluginsList localFetchList;
        PluginsStateList ret = new PluginsStateList();
        ret.isPluginAdmin = checkPermissions && (liu.isAdmin() || liu.getPermissions().mayDevelopPlugins());
        Collection<InstalledPluginDesc> loadedPlugins = this.loadService.getLoadedPlugins();
        for (InstalledPluginDesc loadedPlugin : loadedPlugins) {
            String pluginId = loadedPlugin.desc.id;
            Object settings = null;
            try {
                if (checkPermissions && this.permissionsService.hasPluginPrivilege(liu, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN)) {
                    settings = this.pluginSettingsAccessService.get(liu, pluginId, null);
                }
            }
            catch (DKUSecurityException | IOException e) {
                logger.warn((Object)"Failed to get settings for installed plugin", e);
            }
            PluginStateInfo pluginInfo = PluginStateInfo.fromInstalled(loadedPlugin, settings);
            ret.plugins.add(pluginInfo);
        }
        ret.shouldRestart = this.pluginConfigurationIsDirty;
        Iterator<StorePluginsList.StorePlugin> iterator = this;
        synchronized (iterator) {
            ret.couldFetch = this.fetchedList != null && this.fetchException == null;
            localFetchList = (StorePluginsList)this.fetchedList;
            ret.fetchError = this.fetchException;
        }
        if (localFetchList != null) {
            for (StorePluginsList.StorePlugin fetchedPlugin : localFetchList.items) {
                boolean isInstalled = false;
                ++ret.pluginsNumberInStore;
                for (PluginStateInfo stateInfo : ret.plugins) {
                    if (!stateInfo.id.equals(fetchedPlugin.id)) continue;
                    stateInfo.addStoreData(fetchedPlugin);
                    isInstalled = true;
                }
                if (isInstalled) continue;
                PluginStateInfo pluginInfo = PluginStateInfo.fromStoreData(fetchedPlugin);
                ret.plugins.add(pluginInfo);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginStateInfo getMandatory(String pluginId) throws Exception {
        StorePluginsList localFetchedList;
        PluginStoreService pluginStoreService = this;
        synchronized (pluginStoreService) {
            localFetchedList = (StorePluginsList)this.fetchedList;
        }
        for (InstalledPluginDesc loadedPlugin : this.loadService.getLoadedPlugins()) {
            if (!pluginId.equals(loadedPlugin.desc.id)) continue;
            PluginStateInfo pluginInfo = PluginStateInfo.fromInstalled(loadedPlugin);
            if (localFetchedList != null) {
                for (StorePluginsList.StorePlugin fetchedPlugin : localFetchedList.items) {
                    if (!pluginInfo.id.equals(fetchedPlugin.id)) continue;
                    pluginInfo.addStoreData(fetchedPlugin);
                }
            }
            return pluginInfo;
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin " + pluginId + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pluginId) {
        StorePluginsList localFetchList;
        PluginStoreService pluginStoreService = this;
        synchronized (pluginStoreService) {
            localFetchList = (StorePluginsList)this.fetchedList;
        }
        if (localFetchList != null) {
            return localFetchList.items.stream().anyMatch(item -> item.id.equals(pluginId));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<StorePluginsList.StorePlugin> getStorePluginDesc(String pluginId) {
        StorePluginsList localFetchList;
        PluginStoreService pluginStoreService = this;
        synchronized (pluginStoreService) {
            localFetchList = (StorePluginsList)this.fetchedList;
        }
        if (localFetchList != null) {
            return localFetchList.items.stream().filter(item -> item.id.equals(pluginId)).findFirst();
        }
        return Optional.empty();
    }

    public static FuturePayload buildFutureInstallPayload(String pluginId, boolean update) {
        FuturePayload fp = new FuturePayload();
        fp.action = "plugin_install";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(pluginId, "PLUGIN"));
        fp.withExtra("update", (Object)update);
        fp.displayName = (update ? "Installing" : "Updating") + " plugin";
        return fp;
    }

    public File getPluginArchive(File tmpDir) {
        return new File(tmpDir, "plugin.zip");
    }

    private void installAndActivate(File file, AuthCtx user, boolean isUpdate, File targetDir, InstallationResult ret, DKUtils.SmartLogTailBuilder logTailBuilder) {
        String pluginId = null;
        try {
            pluginId = file.isDirectory() ? PluginInstaller.installFromPath(file, user, isUpdate, targetDir) : PluginInstaller.installFromZip(file, user, isUpdate, targetDir);
            logger.info((Object)"Installation done");
        }
        catch (Exception ex) {
            ret.success = false;
            ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
            ret.errorMessage = "Could not install the plugin";
            if (isUpdate) {
                try {
                    this.loadService.unloadPlugin(pluginId);
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to properly rollback plugin install", (Throwable)e);
                }
            }
            logger.error((Object)"Plugin installation failed", (Throwable)ex);
            return;
        }
        try {
            boolean needsRestart;
            if (isUpdate) {
                this.loadService.unloadPlugin(pluginId);
            }
            try (Transaction tr = this.transactionService.beginRead();){
                ret.pluginDesc = this.loadService.loadAfterStartup(pluginId);
            }
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                PluginSettings settings = this.pluginsRegistryService.getSettings(pluginId);
                this.pluginsRegistryService.setSettings(pluginId, settings);
                t.commit("Bootstrap settings on " + pluginId);
            }
            tr = this.transactionService.beginRead();
            try {
                ret.settings = this.pluginSettingsAccessService.get(user, pluginId, null);
            }
            finally {
                if (tr != null) {
                    tr.close();
                }
            }
            this.pluginConfigurationIsDirty = needsRestart = this.loadService.needsRestart(ret.pluginDesc.desc);
            ret.needsRestart = needsRestart;
            ret.success = true;
            ret.needsReload = true;
            logger.info((Object)("Store plugin install complete: " + pluginId));
            ret.messages.withSuccess((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.INFO_PLUGIN_INSTALL_OK, "Plugin installation complete " + pluginId);
            this.handleCDEImage(pluginId, logTailBuilder, ret, isUpdate);
        }
        catch (Exception ex) {
            ret.success = false;
            ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
            ret.errorMessage = "Could not activate the plugin";
            logger.error((Object)"Plugin installation failed", (Throwable)ex);
        }
    }

    public InstallationResult installUploaded(AuthCtx user, File file, boolean isUpdate, DKUtils.SmartLogTailBuilder logTailBuilder) {
        InstallationResult result = new InstallationResult();
        this.installAndActivate(file, user, isUpdate, null, result, logTailBuilder);
        try {
            this.pubSub.publish(new PluginChangedEvent(result.pluginDesc.desc.id, PluginChangedEvent.ActionType.INSTALLED, user.getIdentifier()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send notification", (Throwable)e);
        }
        return result;
    }

    public FutureResponse<InstallationResult> remove(String pluginId, AuthCtx authCtx) throws Exception {
        DeleteFutureThread ft = new DeleteFutureThread(pluginId, (DSSAuthCtx)authCtx);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public FutureResponse<InstallationResult> downloadAndInstall(String pluginId, AuthCtx authCtx, boolean update) throws Exception {
        InstallFromStoreFutureThread ft = new InstallFromStoreFutureThread(pluginId, (DSSAuthCtx)authCtx, update);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public FutureResponse<InstallationResult> startCloneAndInstall(String repository, String checkout, String path, AuthCtx authCtx, boolean update) throws Exception {
        InstallFromGitSimpleFutureThread ft = new InstallFromGitSimpleFutureThread(repository, checkout, path, authCtx, update);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public FutureResponse<InstallationResult> startUploadAndInstall(AutoDelete tmpDir, AuthCtx authCtx, boolean update) throws Exception {
        InstallFromUploadSimpleFutureThread ft = new InstallFromUploadSimpleFutureThread(tmpDir, authCtx, update);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public InstallationResult movePluginToDev_NT(String pluginId) {
        InstallationResult ret = new InstallationResult();
        File installedDir = RegularPluginsRegistryService.getInstalledPluginFolder(pluginId);
        File devDir = RegularPluginsRegistryService.getDevPluginFolder(pluginId);
        try {
            if (!installedDir.exists()) {
                throw new IOException("Plugin is not installed where it should be.");
            }
            if (devDir.exists()) {
                throw new IOException("A plugin is already at that path in the development environment: " + devDir.getAbsolutePath());
            }
            try (Transaction tr = this.transactionService.beginRead();){
                this.loadService.unloadPlugin(pluginId);
                Files.move(installedDir.toPath(), devDir.toPath(), new CopyOption[0]);
                FileUtils.deleteQuietly((File)new File(devDir, ".git"));
                this.loadService.loadAfterStartup(pluginId);
            }
            ret.success = true;
            ret.needsReload = true;
        }
        catch (Exception ex) {
            ret.success = false;
            ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
            ret.errorMessage = "Could not move the plugin";
            logger.error((Object)"Moving plugin to dev failed", (Throwable)ex);
        }
        return ret;
    }

    private void handleCDEImage(String pluginId, DKUtils.SmartLogTailBuilder logTailBuilder, InstallationResult ir, boolean isUpdate) {
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Building CDE image");){
            if (this.cdeImageBuilderService.shouldRebuildCDEOnPluginChange(pluginId, ir.settings.excludedFromCDE, isUpdate)) {
                logger.info((Object)"Building CDE image");
                BaseImageBuilder builder = new BaseImageBuilder(ContainerExecUtils.BaseImageType.CDE_PLUGINS, new BaseImageBuilder.BaseImageBuildOptions(), logTailBuilder, true, true);
                builder.build(ir.messages);
            } else {
                logger.info((Object)"Store plugin should not be in CDE image, skipping...");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not rebuild CDE image", (Throwable)e);
        }
    }

    public static class PluginsStateList {
        public boolean isPluginAdmin;
        public List<PluginStateInfo> plugins = new ArrayList<PluginStateInfo>();
        public boolean shouldRestart;
        public boolean couldFetch;
        public SerializedError fetchError;
        public int pluginsNumberInStore;
    }

    public static class PluginStateInfo {
        public final String id;
        public final boolean installed;
        public final InstalledPluginDesc installedDesc;
        public boolean inStore;
        public StorePluginsList.StorePlugin storeDesc;
        public final PluginSettingsAccessService.PluginUISettings settings;
        public final PluginExtraInfo extraInfo;

        private PluginStateInfo(String id, boolean installed, boolean inStore, InstalledPluginDesc installedDesc, StorePluginsList.StorePlugin storeDesc, PluginSettingsAccessService.PluginUISettings uiSettings) {
            this.id = id;
            this.installed = installed;
            this.inStore = inStore;
            this.installedDesc = installedDesc;
            this.storeDesc = storeDesc;
            this.settings = uiSettings;
            this.extraInfo = installed ? new PluginExtraInfo(installedDesc) : null;
        }

        public static PluginStateInfo fromStoreData(StorePluginsList.StorePlugin storeDesc) {
            return new PluginStateInfo(storeDesc.id, false, true, null, storeDesc, null);
        }

        public static PluginStateInfo fromInstalled(InstalledPluginDesc installedPluginDesc) {
            return PluginStateInfo.fromInstalled(installedPluginDesc, null);
        }

        public static PluginStateInfo fromInstalled(InstalledPluginDesc installedPluginDesc, PluginSettingsAccessService.PluginUISettings uiSettings) {
            return new PluginStateInfo(installedPluginDesc.desc.id, true, false, installedPluginDesc, null, uiSettings);
        }

        public void addStoreData(StorePluginsList.StorePlugin storeDesc) {
            this.storeDesc = storeDesc;
            this.inStore = true;
        }
    }

    public static class InstallationResult {
        public boolean success;
        public boolean needsReload;
        public boolean needsRestart;
        public SerializedError installationError;
        public String errorMessage;
        public InstalledPluginDesc pluginDesc;
        public PluginSettingsAccessService.PluginUISettings settings;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }

    private class DeleteFutureThread
    extends FutureThread<InstallationResult> {
        private final InstallationResult result;
        private final String pluginId;
        private final DSSAuthCtx authCtx;
        private final FuturePayload futurePayload;

        public DeleteFutureThread(String pluginId, DSSAuthCtx authCtx) {
            super(authCtx);
            this.result = new InstallationResult();
            this.pluginId = pluginId;
            this.authCtx = authCtx;
            this.futurePayload = this.buildFuturePayload(pluginId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InstallationResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            InstallationResult ret = this.result;
            try {
                logger.info((Object)("Looking if plugin with id " + this.pluginId + " is installed"));
                Collection<InstalledPluginDesc> loadedPlugins = PluginStoreService.this.loadService.getLoadedPlugins();
                PluginDesc preexisting = null;
                for (InstalledPluginDesc loadedPlugin : loadedPlugins) {
                    if (!loadedPlugin.desc.id.equals(this.pluginId)) continue;
                    preexisting = loadedPlugin.desc;
                    break;
                }
                if (preexisting == null) {
                    throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin '" + this.pluginId + "' is not installed");
                }
                logger.info((Object)("Plugin " + this.pluginId + " found"));
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not check if plugin is installed";
                return;
            }
            try {
                ret.pluginDesc = PluginStoreService.this.loadService.loadAfterStartup(this.pluginId);
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not load plugin desc";
                return;
            }
            boolean needsRestart = PluginStoreService.this.loadService.needsRestart(ret.pluginDesc.desc);
            PluginSettings settings = null;
            try (Transaction tr = PluginStoreService.this.transactionService.beginRead();){
                settings = PluginStoreService.this.pluginsRegistryService.getSettings(this.pluginId);
            }
            catch (IOException ex) {
                logger.warn((Object)("Error retrieving plugin " + this.pluginId + " settings. Will not attempt to remove associated managed code env, if any."), (Throwable)ex);
            }
            if (null != settings && StringUtils.isNotEmpty((String)settings.codeEnvName)) {
                this.handleCodeEnvRemoval(settings);
            }
            try (RWTransaction t = PluginStoreService.this.transactionService.beginWriteAsDSS();){
                PluginStoreService.this.pluginsRegistryService.removeSettings(this.pluginId);
                t.commitV("Removed configuration of plugin '%s'", new Object[]{this.pluginId});
            }
            catch (IOException ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not delete the settings of the plugin";
                logger.error((Object)"Deletion of the settings of the plugin failed", (Throwable)ex);
                return;
            }
            PluginStoreService.this.loadService.unloadPlugin(this.pluginId);
            try {
                File installedPluginFolder = ret.pluginDesc.origin == InstalledPluginDesc.PluginOrigin.DEV ? DKUFileUtils.getWithin((File)DevPluginsService.getPluginsRoot(), (String[])new String[]{this.pluginId}) : RegularPluginsRegistryService.getInstalledPluginFolder(this.pluginId);
                DKUFileUtils.forceDelete((File)installedPluginFolder);
                logger.info((Object)("Removed plugin directory " + installedPluginFolder.getCanonicalPath()));
            }
            catch (IOException ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not delete the directory of the plugin";
                logger.error((Object)"Deletion of plugin directory failed", (Throwable)ex);
                return;
            }
            ret.needsRestart = needsRestart;
            ret.success = true;
            ret.needsReload = true;
            PluginStoreService.this.pluginConfigurationIsDirty = needsRestart;
            logger.info((Object)("Plugin deletion complete: " + this.pluginId));
            try {
                PluginStoreService.this.pubSub.publish(new PluginChangedEvent(this.pluginId, PluginChangedEvent.ActionType.DELETED, this.owner.getIdentifier()));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to send notification", (Throwable)e);
            }
            PluginStoreService.this.loadService.reloadDevPlugins();
        }

        private void handleCodeEnvRemoval(PluginSettings settings) {
            CodeEnvModel.EnvLang pluginEnvLang = CodeEnvModel.EnvLang.PYTHON;
            boolean isPluginManagedCodeEnv = false;
            try {
                switch (ApplicationConfigurator.getNodeType()) {
                    case AUTOMATION: {
                        CodeEnvModel.AutomationEnvRootDef envRootDef = PluginStoreService.this.automationNodeCodeEnvsService.getEnvRootDef(pluginEnvLang, settings.codeEnvName);
                        isPluginManagedCodeEnv = null != envRootDef && CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED == envRootDef.deploymentMode;
                        break;
                    }
                    case DESIGN: {
                        CodeEnvModel.AbstractEnvDesc envDesc = PluginStoreService.this.designNodeCodeEnvsService.getEnvDesc(pluginEnvLang, settings.codeEnvName);
                        isPluginManagedCodeEnv = null != envDesc && CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED == envDesc.deploymentMode;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception accessing associated code env. Will not try to remove it.", (Throwable)e);
            }
            if (!isPluginManagedCodeEnv) {
                logger.info((Object)("Code env associated to plugin " + this.pluginId + " does not exist or is not managed by the plugin. Not deleting it."));
            } else {
                try {
                    PluginStoreService.this.permissionsService.checkCodeEnvPrivileges(this.authCtx, pluginEnvLang, settings.codeEnvName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
                    DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
                    CodeEnvModel.EnvDeletionResult edr = switch (ApplicationConfigurator.getNodeType()) {
                        case ApplicationConfigurator.DSSNodeType.AUTOMATION -> PluginStoreService.this.automationNodeCodeEnvsService.doDeleteCodeEnv(pluginEnvLang, settings.codeEnvName, this.authCtx, logTailBuilder);
                        case ApplicationConfigurator.DSSNodeType.DESIGN -> PluginStoreService.this.designNodeCodeEnvsService.doDeleteCodeEnv(pluginEnvLang, settings.codeEnvName, this.authCtx, logTailBuilder);
                        default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
                    };
                    String smartLog = Joiner.on((String)"\n").join((Iterable)logTailBuilder.get().getLines());
                    if (!edr.messages.messages.isEmpty()) {
                        edr.messages.summarize();
                        InfoMessage.Severity s = switch (edr.messages.maxSeverity) {
                            case InfoMessage.Severity.ERROR -> InfoMessage.Severity.ERROR;
                            case InfoMessage.Severity.WARNING -> InfoMessage.Severity.WARNING;
                            case InfoMessage.Severity.INFO -> InfoMessage.Severity.INFO;
                            case InfoMessage.Severity.SUCCESS -> InfoMessage.Severity.SUCCESS;
                            default -> throw new RuntimeException("Unhandled severity");
                        };
                        logger.log((Priority)s.logLevel, (Object)("On deletion of code env associated to plugin " + this.pluginId + ":" + edr.messages.report()));
                        logger.log((Priority)s.logLevel, (Object)("On deletion of code env associated to plugin " + this.pluginId + ":" + smartLog));
                    }
                }
                catch (DKUSecurityException e) {
                    logger.warn((Object)("Did not have the privileges to remove managed code env " + settings.codeEnvName + ". Did not remove it."), (Throwable)e);
                }
            }
        }

        public FuturePayload buildFuturePayload(String pluginId) {
            FuturePayload fp = new FuturePayload();
            fp.action = "plugin_delete";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(pluginId, "PLUGIN"));
            fp.displayName = "Deleting plugin";
            return fp;
        }
    }

    private class InstallFromStoreFutureThread
    extends FutureThread<InstallationResult> {
        private final InstallationResult result;
        private final String pluginId;
        private final boolean update;
        private final ProxySettings proxySettings;
        private final FuturePayload futurePayload;
        final DKUtils.SmartLogTailBuilder logTailBuilder;

        public InstallFromStoreFutureThread(String pluginId, DSSAuthCtx authCtx, boolean update) {
            super(authCtx);
            this.result = new InstallationResult();
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.pluginId = pluginId;
            this.update = update;
            this.proxySettings = ApplicationConfigurator.getProxySettings();
            this.futurePayload = PluginStoreService.buildFutureInstallPayload(pluginId, update);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InstallationResult getResult() {
            return this.result;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public double getDangerosity() {
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Transaction tr;
            InstallationResult ret = this.result;
            Map<String, StorePluginsList.StorePlugin> lastestFetchedPlugins = this.getFetchedAsMap();
            AutoDelete tempFile = null;
            try {
                if (!lastestFetchedPlugins.containsKey(this.pluginId)) {
                    throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin has since been removed from the store.");
                }
                Collection<InstalledPluginDesc> loadedPlugins = PluginStoreService.this.loadService.getLoadedPlugins();
                PluginDesc preexisting = null;
                for (InstalledPluginDesc loadedPlugin : loadedPlugins) {
                    if (!loadedPlugin.desc.id.equals(this.pluginId)) continue;
                    preexisting = loadedPlugin.desc;
                }
                if (this.update && preexisting == null) {
                    throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin '" + this.pluginId + "' is not installed");
                }
                if (!this.update && preexisting != null) {
                    throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Plugin '" + this.pluginId + "' is already installed.");
                }
                logger.info((Object)("Installing from plugin store: " + this.pluginId));
                StorePluginsList.StorePlugin storePlugin = lastestFetchedPlugins.get(this.pluginId);
                logger.info((Object)("Downloading from " + storePlugin.downloadURL));
                tempFile = DSSTempUtils.getTempFile((String)"plugin-download", (String)this.pluginId, (String)"zip");
                HTTPClientUtils.downloadToFile((String)storePlugin.downloadURL, (File)tempFile, PluginStoreService.this.settingsService.getCustomHeadersForTracking(this.owner), (ProxySettings)this.proxySettings);
                logger.info((Object)"Download complete");
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not fetch the plugin";
                logger.error((Object)("Could not fetch the plugin : " + this.pluginId), (Throwable)ex);
                return;
            }
            try {
                PluginInstaller.installFromZip((File)tempFile, this.owner, this.update, RegularPluginsRegistryService.getInstalledPluginFolder(this.pluginId));
                logger.info((Object)"Installation done");
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not install the plugin";
                if (this.update) {
                    PluginStoreService.this.loadService.unloadPlugin(this.pluginId);
                }
                logger.error((Object)"Plugin installation failed", (Throwable)ex);
                return;
            }
            finally {
                try {
                    if (tempFile != null && tempFile.exists()) {
                        DKUFileUtils.forceDelete((File)tempFile);
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to delete the downloaded plugin file", (Throwable)ex);
                }
            }
            try {
                tr = PluginStoreService.this.transactionService.beginRead();
                try {
                    if (this.update) {
                        PluginStoreService.this.loadService.unloadPlugin(this.pluginId);
                    }
                    ret.pluginDesc = PluginStoreService.this.loadService.loadAfterStartup(this.pluginId);
                }
                finally {
                    if (tr != null) {
                        tr.close();
                    }
                }
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not activate the plugin";
                logger.error((Object)"Plugin installation failed", (Throwable)ex);
                return;
            }
            try (RWTransaction t = PluginStoreService.this.transactionService.beginWriteAsDSS();){
                PluginSettings settings = PluginStoreService.this.pluginsRegistryService.getSettings(this.pluginId);
                PluginStoreService.this.pluginsRegistryService.setSettings(this.pluginId, settings);
                t.commit("Bootstrap settings on " + this.pluginId);
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not activate the plugin";
                logger.error((Object)"Plugin installation failed", (Throwable)ex);
                return;
            }
            try {
                tr = PluginStoreService.this.transactionService.beginRead();
                try {
                    boolean needsRestart;
                    ret.settings = PluginStoreService.this.pluginSettingsAccessService.get(this.owner, this.pluginId, null);
                    PluginStoreService.this.pluginConfigurationIsDirty = needsRestart = PluginStoreService.this.loadService.needsRestart(ret.pluginDesc.desc);
                    ret.needsRestart = needsRestart;
                    ret.success = true;
                    ret.needsReload = true;
                    logger.info((Object)("Store plugin install complete: " + this.pluginId));
                }
                finally {
                    if (tr != null) {
                        tr.close();
                    }
                }
            }
            catch (Exception ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not activate the plugin";
                logger.error((Object)"Plugin installation failed", (Throwable)ex);
            }
            if (ret.success) {
                ret.messages.withSuccess((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.INFO_PLUGIN_INSTALL_OK, "Store plugin installation complete " + this.pluginId);
                PluginStoreService.this.handleCDEImage(this.pluginId, this.logTailBuilder, ret, this.update);
                try {
                    PluginStoreService.this.pubSub.publish(new PluginChangedEvent(this.pluginId, PluginChangedEvent.ActionType.INSTALLED, this.owner.getIdentifier()));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to send notification", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, StorePluginsList.StorePlugin> getFetchedAsMap() {
            StorePluginsList localFetchedList;
            InstallFromStoreFutureThread installFromStoreFutureThread = this;
            synchronized (installFromStoreFutureThread) {
                localFetchedList = (StorePluginsList)PluginStoreService.this.fetchedList;
            }
            HashMap map = Maps.newHashMap();
            if (localFetchedList != null) {
                for (StorePluginsList.StorePlugin fetchedPlugin : localFetchedList.items) {
                    map.put(fetchedPlugin.id, fetchedPlugin);
                }
            }
            return map;
        }
    }

    private class InstallFromGitSimpleFutureThread
    extends SimpleFutureThread<InstallationResult> {
        private final String repository;
        private final String checkout;
        private final String path;
        private final boolean isUpdate;
        private final FuturePayload futurePayload;
        final DKUtils.SmartLogTailBuilder logTailBuilder;

        InstallFromGitSimpleFutureThread(String repository, String checkout, String path, AuthCtx authCtx, boolean isUpdate) {
            super(authCtx);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.repository = repository;
            this.checkout = checkout;
            this.path = path;
            this.isUpdate = isUpdate;
            this.futurePayload = PluginStoreService.buildFutureInstallPayload(repository, isUpdate);
        }

        @Override
        protected InstallationResult compute() throws Exception {
            InstallationResult installationResult;
            block20: {
                AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-clones", (String)Long.toString(System.currentTimeMillis()));
                try {
                    GitRemoteCommands git = new GitRemoteCommands((File)tmpDir);
                    git.shallowClone(this.owner, this.repository, this.checkout);
                    Object outputDir = tmpDir;
                    if (StringUtils.isNotBlank((String)this.path) && !((File)(outputDir = new File((File)outputDir, this.path))).exists()) {
                        throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_WRONG_PATH, "Given path for plugin does not exist in repository: '" + this.path + "'");
                    }
                    if (!((File)outputDir).setExecutable(true, false)) {
                        logger.error((Object)String.format("Unable to change execution permissions on file %s", ((File)outputDir).getAbsolutePath()));
                    }
                    if (!((File)outputDir).setReadable(true, false)) {
                        logger.error((Object)String.format("Unable to change read permissions on file %s", ((File)outputDir).getAbsolutePath()));
                    }
                    InstallationResult ir = PluginStoreService.this.installUploaded(this.owner, (File)outputDir, this.isUpdate, this.logTailBuilder);
                    if (ir.success) {
                        String pluginId = ir.pluginDesc.desc.id;
                        File targetDir = RegularPluginsRegistryService.getInstalledPluginFolder(pluginId);
                        File stateFile = new File(targetDir, "state.json");
                        InstalledPluginState ips = (InstalledPluginState)JSON.parseFile((File)stateFile, InstalledPluginState.class);
                        ips.gitState = new InstalledPluginState.PluginGitState();
                        ips.gitState.enabled = true;
                        ips.gitState.repository = this.repository;
                        ips.gitState.path = StringUtils.defaultString((String)this.path);
                        ips.gitState.checkout = StringUtils.defaultString((String)this.checkout);
                        JSON.prettyToFile((Object)ips, (File)stateFile);
                        try (Transaction t = PluginStoreService.this.transactionService.beginRead();){
                            PluginStoreService.this.loadService.reloadPlugin(pluginId);
                        }
                    }
                    installationResult = ir;
                    if (tmpDir == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (tmpDir != null) {
                            try {
                                tmpDir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CodedException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_FAILED_TO_CLONE_AND_INSTALL, "Plugin could not be cloned and installed from '" + this.repository + "'", (Throwable)ex);
                    }
                }
                tmpDir.close();
            }
            return installationResult;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }
    }

    private class InstallFromUploadSimpleFutureThread
    extends SimpleFutureThread<InstallationResult> {
        private final AutoDelete tmpDir;
        private final boolean isUpdate;
        private final FuturePayload futurePayload;
        final DKUtils.SmartLogTailBuilder logTailBuilder;

        InstallFromUploadSimpleFutureThread(AutoDelete tmpDir, AuthCtx authCtx, boolean isUpdate) {
            super(authCtx);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.tmpDir = tmpDir;
            this.isUpdate = isUpdate;
            this.futurePayload = PluginStoreService.buildFutureInstallPayload(null, isUpdate);
        }

        @Override
        protected InstallationResult compute() {
            return PluginStoreService.this.installUploaded(this.owner, PluginStoreService.this.getPluginArchive((File)this.tmpDir), this.isUpdate, this.logTailBuilder);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public void postRunCleanup() {
            this.tmpDir.close();
        }
    }
}

