/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PromptStudioConnectionsUtils {
    private PromptStudioConnectionsUtils() {
    }

    public static Set<String> listConnectionNames(PromptStudio promptStudio) {
        return promptStudio.prompts.stream().filter(prompt -> prompt.llmId != null).map(prompt -> LLMStructuredRef.decodeId((String)prompt.llmId).connection).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void remapPrompt(PromptStudio.PromptStudioPrompt prompt, Map<String, String> replacements) {
        if (prompt.llmId == null) {
            return;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(prompt.llmId);
        if (ref.connection == null) {
            return;
        }
        String newConnection = replacements.get(ref.connection);
        if (newConnection != null) {
            ref.setConnection(newConnection);
            prompt.llmId = ref.encodeToId();
        }
    }

    public static void remapConnections(PromptStudio promptStudio, Map<String, String> replacements) {
        for (PromptStudio.PromptStudioPrompt settings : promptStudio.prompts) {
            PromptStudioConnectionsUtils.remapPrompt(settings, replacements);
        }
    }
}

