/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.ObjectCustomMetadata;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.datalineage.RecipeManualLineageConfig;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.OverrideTable;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum RecipeDeserializer implements JsonDeserializer<SerializedRecipe>
{
    INSTANCE;

    private static final Map<String, Class<? extends RecipeParams>> paramsMap;

    public static void registerType(String type, Class<? extends RecipeParams> paramsClass) {
        paramsMap.put(type, paramsClass);
    }

    public SerializedRecipe deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Class<? extends RecipeParams> paramsClass;
        SerializedRecipe ret = new SerializedRecipe();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.has("projectKey")) {
            ret.projectKey = jsonObj.get("projectKey").getAsString();
        }
        if (jsonObj.has("name") && !jsonObj.get("name").isJsonNull()) {
            ret.name = jsonObj.get("name").getAsString();
        }
        ret.type = jsonObj.get("type").getAsString();
        if (jsonObj.has("inputs")) {
            ret.setInputs_INT((Map)jsonDeserializationContext.deserialize(jsonObj.get("inputs"), new TypeToken<Map<String, SerializedRecipe.InputRole>>(){}.getType()));
        }
        if (jsonObj.has("outputs")) {
            ret.setOutputs_INT((Map)jsonDeserializationContext.deserialize(jsonObj.get("outputs"), new TypeToken<Map<String, SerializedRecipe.OutputRole>>(){}.getType()));
        }
        if (jsonObj.has("neverRecomputeExistingPartitions")) {
            ret.neverRecomputeExistingPartitions = jsonObj.get("neverRecomputeExistingPartitions").getAsBoolean();
        }
        if (jsonObj.has("hashPropagationBehavior")) {
            ret.hashPropagationBehavior = SerializedRecipe.RecipeHashPropagationBehavior.valueOf(jsonObj.get("hashPropagationBehavior").getAsString());
        }
        if (jsonObj.has("redispatchPartitioning")) {
            ret.redispatchPartitioning = jsonObj.get("redispatchPartitioning").getAsBoolean();
        }
        if (jsonObj.has("maxRunningActivities")) {
            ret.maxRunningActivities = jsonObj.get("maxRunningActivities").getAsInt();
        }
        if (jsonObj.has("manualLineageConfig")) {
            ret.manualLineageConfig = (RecipeManualLineageConfig)jsonDeserializationContext.deserialize(jsonObj.get("manualLineageConfig"), new TypeToken<RecipeManualLineageConfig>(){}.getType());
        }
        if ((paramsClass = paramsMap.get(ret.type)) == null) {
            throw new JsonParseException("recipe type " + ret.type + " is unknown");
        }
        JsonElement paramJson = jsonObj.get("params");
        if (paramJson != null) {
            ret.params = (RecipeParams)jsonDeserializationContext.deserialize(paramJson, paramsClass);
        }
        if (jsonObj.has("shortDesc")) {
            ret.shortDesc = jsonObj.get("shortDesc").getAsString();
        }
        if (jsonObj.has("description")) {
            ret.description = jsonObj.get("description").getAsString();
        }
        if (jsonObj.has("checklists")) {
            ret.checklists = (Checklists)jsonDeserializationContext.deserialize(jsonObj.get("checklists"), Checklists.class);
        }
        if (jsonObj.has("doc")) {
            ret.doc = jsonObj.get("doc").getAsString();
        }
        if (jsonObj.has("tags")) {
            ret.tags = (List)jsonDeserializationContext.deserialize(jsonObj.get("tags"), List.class);
        }
        if (jsonObj.has("customMeta")) {
            ret.customMeta = (ObjectCustomMetadata)jsonDeserializationContext.deserialize(jsonObj.get("customMeta"), ObjectCustomMetadata.class);
        }
        if (jsonObj.has("variables")) {
            ret.variables = (JsonObject)jsonDeserializationContext.deserialize(jsonObj.get("variables"), JsonObject.class);
        }
        if (jsonObj.has("dkuProperties")) {
            ret.dkuProperties = (List)jsonDeserializationContext.deserialize(jsonObj.get("dkuProperties"), new TypeToken<List<AbstractSQLConnection.CustomDatabaseProperty>>(){}.getType());
        }
        if (jsonObj.has("overrideTable")) {
            ret.overrideTable = (OverrideTable)jsonDeserializationContext.deserialize(jsonObj.get("overrideTable"), OverrideTable.class);
        }
        if (jsonObj.has("versionTag")) {
            ret.versionTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("versionTag"), VersionTag.class);
        }
        if (jsonObj.has("creationTag")) {
            ret.creationTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("creationTag"), VersionTag.class);
        }
        if (jsonObj.has("labels")) {
            ret.labels = (List)jsonDeserializationContext.deserialize(jsonObj.get("labels"), new TypeToken<List<SimpleKeyValue>>(){}.getType());
        }
        if (jsonObj.has("customFields")) {
            ret.customFields = jsonObj.getAsJsonObject("customFields");
        }
        return ret;
    }

    static {
        JSON.registerAdapter(SerializedRecipe.class, (Object)((Object)INSTANCE));
        paramsMap = Collections.synchronizedMap(new HashMap());
    }
}

