/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.nlp.common.LLMRecipeMeta;
import com.dataiku.dip.recipes.nlp.common.NLPRecipePayloadParams;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;

public abstract class NLPRecipeMeta<P extends NLPRecipePayloadParams>
extends LLMRecipeMeta<P> {
    private static final String ROLE_INPUT_MODEL = "model";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp");

    protected NLPRecipeMeta(Class<P> paramsClass) {
        super(paramsClass);
    }

    @Override
    public void updateImplicitIOBeforeSave(String projectKey, SerializedRecipe sr, String payload) {
        NLPRecipePayloadParams payloadParams = (NLPRecipePayloadParams)this.loadPayload(payload);
        if (payloadParams == null || StringUtils.isBlank((String)payloadParams.llmId)) {
            return;
        }
        try {
            LLMStructuredRef ref = LLMStructuredRef.decodeId(payloadParams.llmId);
            switch (ref.type) {
                case SAVED_MODEL_FINETUNED_AZURE_OPENAI: 
                case SAVED_MODEL_FINETUNED_BEDROCK: 
                case SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER: 
                case SAVED_MODEL_FINETUNED_OPENAI: 
                case SAVED_MODEL_FINETUNED_VERTEX: 
                case SAVED_MODEL_AGENT: 
                case RETRIEVAL_AUGMENTED: {
                    if (ref.savedModelSmartId != null) {
                        sr.clearInputsForRole(ROLE_INPUT_MODEL);
                        sr.addInput(ROLE_INPUT_MODEL, ref.savedModelSmartId);
                    }
                    break;
                }
                default: {
                    sr.clearInputsForRole(ROLE_INPUT_MODEL);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to update implicit input on NLP recipe", (Throwable)e);
        }
    }
}

