/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.prompt;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.utils.DKULogger;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PromptPlaceholderUtils {
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prompt");

    public static boolean verifyPlaceholders(String prompt, Map<String, Column> inputColumns) {
        Pattern p = Pattern.compile("\\[([^\\]]+)\\]");
        Matcher m = p.matcher(prompt);
        boolean placeholdersValid = true;
        while (m.find()) {
            String placeholder = m.group(1);
            if (inputColumns.containsKey(placeholder)) continue;
            logger.warn((Object)String.format("Placeholder [%s] does not match any column in the input dataset.", placeholder));
            placeholdersValid = false;
        }
        return placeholdersValid;
    }

    public static String expandPlaceholders(String prompt, Row row, Map<String, Column> inputColumns) {
        Pattern p = Pattern.compile("\\[([^\\]]+)\\]");
        Matcher m = p.matcher(prompt);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
            String placeholder = m.group(1);
            if (inputColumns.containsKey(placeholder)) {
                String replacement = row.get(inputColumns.get(placeholder));
                sb.append(replacement);
                continue;
            }
            sb.append(m.group());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

