/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.recipes.streaming.python.FunctionCheckpoint;
import com.dataiku.dip.recipes.streaming.python.RowsPullingHandler;
import com.dataiku.dip.recipes.streaming.python.RowsPushingHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class RowsSplittingHandler {
    private final int n;
    private final RowsPullingHandler rowsPullingHandler;
    private final RowsPushingHandler rowsPushingHandler;
    private final Runnable notifyError;
    private final Map<String, Long> windowDefinitions;
    private final LinkedBlockingQueue<InputRowsBatch> chunks = new LinkedBlockingQueue();
    private final Map<String, List<RowsPullingHandler.InputRow>> lastRows = Maps.newHashMap();
    private final Object processing = new Object();
    private final LinkedBlockingQueue<InProcess> inProcess;
    private final ToProcessingThread toProcessing = new ToProcessingThread();
    private final FromProcessedThread fromProcessed = new FromProcessedThread();
    private final Map<String, Long> firstRemoveFromWindowAtBeginning = Maps.newHashMap();
    private volatile boolean closed;
    private static Logger logger = Logger.getLogger((String)"dip.streaming.function.rows.split");

    public RowsSplittingHandler(int nbChunks, int pipelineDepth, RowsPullingHandler rowsPullingHandler, RowsPushingHandler rowsPushingHandler, Runnable notifyError) {
        logger.info((Object)("Split with pipelineDepth=" + pipelineDepth + " and nbChunks=" + nbChunks));
        this.n = nbChunks;
        this.inProcess = new LinkedBlockingQueue(pipelineDepth);
        this.rowsPullingHandler = rowsPullingHandler;
        this.rowsPushingHandler = rowsPushingHandler;
        this.notifyError = notifyError;
        this.windowDefinitions = rowsPullingHandler.getWindowDefinitions();
    }

    public void startSplit() {
        this.toProcessing.start();
        this.fromProcessed.start();
    }

    public boolean startInitIfNeeded() throws InterruptedException {
        return this.rowsPushingHandler.startInitIfNeeded();
    }

    public void notifyInit(boolean done) {
        this.rowsPushingHandler.notifyInit(done);
    }

    public void waitForInitDone() throws InterruptedException {
        this.rowsPushingHandler.waitForInitDone();
    }

    public void waitForAllPushThreadsStarted() throws InterruptedException {
        this.rowsPushingHandler.waitForAllPushThreadsStarted();
    }

    public InputRowsBatch getChunk() throws InterruptedException {
        return this.chunks.poll(5L, TimeUnit.SECONDS);
    }

    public void returnChunk(InputRowsBatch chunk) throws InterruptedException {
        this.chunks.put(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InProcess startBatch(int index) throws InterruptedException {
        InProcess ret = new InProcess();
        InputRowsBatch inputBatch = this.rowsPullingHandler.takeRowsToProcess();
        if (inputBatch == null) {
            this.chunks.put(new InputRowsBatch());
            return null;
        }
        ret.current = inputBatch.checkpoint;
        ret.index = index;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("  + " + inputBatch.inputs.keySet().stream().map(k -> k + " -> " + inputBatch.inputs.get((Object)k).rows.size()).collect(Collectors.joining(", "))));
        }
        ArrayList newChunks = Lists.newArrayList();
        if (this.n == 1) {
            ret.splitCount = 1;
            inputBatch.split = 0;
            inputBatch.index = ret.index;
            newChunks.add(inputBatch);
        } else {
            ArrayList allRows = Lists.newArrayList();
            for (Map.Entry<String, InputRowsElement> input : inputBatch.inputs.entrySet()) {
                for (RowsPullingHandler.InputRow row : input.getValue().rows) {
                    allRows.add(new InputRowWithFullId(input.getKey(), row));
                }
            }
            Collections.sort(allRows, new Comparator<InputRowWithFullId>(){

                @Override
                public int compare(InputRowWithFullId a, InputRowWithFullId b) {
                    long d = a.row.ts - b.row.ts;
                    if (d < 0L) {
                        return -1;
                    }
                    if (d > 0L) {
                        return 1;
                    }
                    long d2 = a.row.idx - b.row.idx;
                    if (d2 < 0L) {
                        return -1;
                    }
                    if (d2 > 0L) {
                        return 1;
                    }
                    return a.fullId.compareTo(b.fullId);
                }
            });
            int N = allRows.size();
            ret.splitCount = Math.min(N, this.n);
            HashMap firstRemoveFromWindowAtBeginning = Maps.newHashMap();
            Map<String, Long> map = this.firstRemoveFromWindowAtBeginning;
            synchronized (map) {
                firstRemoveFromWindowAtBeginning.putAll(this.firstRemoveFromWindowAtBeginning);
            }
            for (int i = 0; i < ret.splitCount; ++i) {
                InputRowsBatch chunk = new InputRowsBatch();
                chunk.split = i;
                chunk.index = ret.index;
                chunk.checkpoint = inputBatch.checkpoint;
                for (Map.Entry<String, InputRowsElement> input : inputBatch.inputs.entrySet()) {
                    InputRowsElement element = new InputRowsElement();
                    String fullId = input.getKey();
                    element.removeFromWindowAtBeginning = firstRemoveFromWindowAtBeginning.getOrDefault(fullId, input.getValue().removeFromWindowAtBeginning);
                    element.removeFromWindowAtEnd = 0L;
                    chunk.inputs.put(fullId, element);
                }
                int startRowNb = N * i / ret.splitCount;
                int endRowNb = N * (i + 1) / ret.splitCount;
                for (int k2 = startRowNb; k2 < endRowNb; ++k2) {
                    InputRowWithFullId added = (InputRowWithFullId)allRows.get(k2);
                    chunk.inputs.get((Object)added.fullId).rows.add(added.row);
                }
                for (InputRowsElement input : chunk.inputs.values()) {
                    if (input.rows.isEmpty()) continue;
                    long startIdx = input.rows.get((int)0).idx;
                    long endIdx = input.rows.get((int)0).idx;
                    for (RowsPullingHandler.InputRow row : input.rows) {
                        startIdx = Math.min(startIdx, row.idx);
                        endIdx = Math.max(endIdx, row.idx);
                    }
                    input.range = new RowsPullingHandler.IndexRange(startIdx, endIdx);
                }
                newChunks.add(chunk);
            }
        }
        Map<String, List<RowsPullingHandler.InputRow>> map = this.lastRows;
        synchronized (map) {
            for (String fullId : this.windowDefinitions.keySet()) {
                InputRowsElement elem = inputBatch.inputs.get(fullId);
                List rows = this.lastRows.getOrDefault(fullId, new ArrayList());
                if (elem.removeFromWindowAtEnd > 0L) {
                    ret.removeFromWindowAtEnd.put(fullId, elem.removeFromWindowAtEnd);
                }
                rows.addAll(elem.rows);
                this.lastRows.put(fullId, rows);
            }
        }
        this.addToInProcess(ret);
        for (InputRowsBatch chunk : newChunks) {
            this.chunks.put(chunk);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInProcess(InProcess b) throws InterruptedException {
        this.inProcess.put(b);
        if (b.splitCount == 0 && b.processed.isEmpty()) {
            Object object = this.processing;
            synchronized (object) {
                b.done = true;
                this.processing.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveProcessed(OutputRowsBatch batch) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("  <- batch " + batch.index + " / " + batch.split));
        }
        Object object = this.processing;
        synchronized (object) {
            for (InProcess input : this.inProcess) {
                if (input.index != batch.index) continue;
                input.processed.add(batch);
                if (input.processed.size() != input.splitCount) break;
                input.done = true;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("    done " + batch.index));
                }
                this.processing.notifyAll();
                break;
            }
        }
    }

    public InProcess getBatchDone() throws Exception {
        InProcess input = this.inProcess.peek();
        if (input == null || !input.done) {
            return null;
        }
        return this.inProcess.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endBatch(InProcess input) throws Exception {
        Collections.sort(input.processed, new Comparator<OutputRowsBatch>(){

            @Override
            public int compare(OutputRowsBatch a, OutputRowsBatch b) {
                return a.split - b.split;
            }
        });
        OutputRowsBatch output = new OutputRowsBatch();
        output.checkpoint = input.current;
        for (OutputRowsBatch chunk : input.processed) {
            for (Map.Entry<String, List<List<Object>>> rows : chunk.rows.entrySet()) {
                String fullId = rows.getKey();
                List l = output.rows.getOrDefault(fullId, new ArrayList());
                l.addAll((Collection)rows.getValue());
                output.rows.put(fullId, l);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("  + " + output.rows.keySet().stream().map(k -> k + " -> " + output.rows.get(k).size()).collect(Collectors.joining(", "))));
        }
        this.rowsPushingHandler.giveRowsToProcess(output);
        Map<String, Long> map = this.lastRows;
        synchronized (map) {
            for (String fullId : input.removeFromWindowAtEnd.keySet()) {
                long minTs = input.removeFromWindowAtEnd.get(fullId);
                ArrayList filtered = Lists.newArrayList();
                for (RowsPullingHandler.InputRow row : (List)this.lastRows.getOrDefault(fullId, new ArrayList())) {
                    if (row.ts < minTs) continue;
                    filtered.add(row);
                }
                this.lastRows.put(fullId, filtered);
            }
        }
        map = this.firstRemoveFromWindowAtBeginning;
        synchronized (map) {
            this.firstRemoveFromWindowAtBeginning.putAll(input.removeFromWindowAtEnd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, InputWindowElement> getWindowForRanges(Map<String, RowsPullingHandler.IndexRange> ranges) {
        HashMap windows = Maps.newHashMap();
        for (Map.Entry<String, RowsPullingHandler.IndexRange> window : ranges.entrySet()) {
            String fullId = window.getKey();
            RowsPullingHandler.IndexRange range = window.getValue();
            InputWindowElement elem = new InputWindowElement();
            Map<String, List<RowsPullingHandler.InputRow>> map = this.lastRows;
            synchronized (map) {
                for (RowsPullingHandler.InputRow row : (List)this.lastRows.getOrDefault(fullId, new ArrayList())) {
                    if (row.idx < range.start || row.idx > range.end) continue;
                    elem.rows.add(row);
                }
            }
            windows.put(fullId, elem);
        }
        return windows;
    }

    public Map<String, Schema> getInputSchemas() {
        return this.rowsPullingHandler.getSchemas();
    }

    public Map<String, Schema> getOutputSchemas() throws IOException {
        return this.rowsPushingHandler.getSchemas();
    }

    public Map<String, Long> getWindowDefinitions() {
        return this.rowsPullingHandler.getWindowDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSplit() {
        logger.info((Object)("Stop split closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this.processing;
        synchronized (object) {
            this.processing.notifyAll();
        }
        this.toProcessing.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorSplit() {
        logger.info((Object)("Stop split closed=" + this.closed + " on " + String.valueOf(this)));
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this.processing;
        synchronized (object) {
            this.processing.notifyAll();
        }
        this.toProcessing.interrupt();
        this.fromProcessed.interrupt();
        if (this.notifyError != null) {
            this.notifyError.run();
        }
    }

    public class ToProcessingThread
    extends Thread {
        public ToProcessingThread() {
            super("split-to-processing");
        }

        @Override
        public void run() {
            try {
                int readIndex = 0;
                while (!RowsSplittingHandler.this.closed) {
                    InProcess b;
                    if ((b = RowsSplittingHandler.this.startBatch(readIndex++)) == null) {
                        logger.info((Object)"Splitting done");
                        return;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("startBatch " + b.index + " / " + b.splitCount));
                }
                RowsSplittingHandler.this.stopSplit();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to produce input data splits", (Throwable)e);
                RowsSplittingHandler.this.errorSplit();
            }
        }
    }

    public class FromProcessedThread
    extends Thread {
        public FromProcessedThread() {
            super("split-from-processed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!RowsSplittingHandler.this.closed) {
                    ArrayList done = Lists.newArrayList();
                    Iterator iterator = RowsSplittingHandler.this.processing;
                    synchronized (iterator) {
                        InProcess input = RowsSplittingHandler.this.getBatchDone();
                        while (input != null) {
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("endBatch " + input.index));
                            }
                            done.add(input);
                            input = RowsSplittingHandler.this.getBatchDone();
                        }
                        if (done.isEmpty()) {
                            RowsSplittingHandler.this.processing.wait();
                        }
                    }
                    for (InProcess input : done) {
                        RowsSplittingHandler.this.endBatch(input);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to merge processed data splits", (Throwable)e);
                RowsSplittingHandler.this.errorSplit();
            }
            finally {
                RowsSplittingHandler.this.stopSplit();
            }
        }
    }

    public static class InputRowsBatch {
        public Map<String, InputRowsElement> inputs = Maps.newHashMap();
        public FunctionCheckpoint checkpoint;
        public int split;
        public int index;
    }

    public class InProcess {
        public int index;
        public FunctionCheckpoint current;
        public int splitCount;
        public List<OutputRowsBatch> processed = Lists.newArrayList();
        public Map<String, Long> removeFromWindowAtEnd = Maps.newHashMap();
        public volatile boolean done;
    }

    public static class InputRowsElement {
        public RowsPullingHandler.IndexRange range;
        public List<RowsPullingHandler.InputRow> rows = Lists.newArrayList();
        public long removeFromWindowAtBeginning;
        public long removeFromWindowAtEnd;
        public long windowSize;
    }

    private static class InputRowWithFullId {
        private RowsPullingHandler.InputRow row;
        private String fullId;

        public InputRowWithFullId(String fullId, RowsPullingHandler.InputRow row) {
            this.row = row;
            this.fullId = fullId;
        }
    }

    public static class OutputRowsBatch {
        public Map<String, List<List<Object>>> rows = Maps.newHashMap();
        public FunctionCheckpoint checkpoint;
        public int split;
        public int index;
    }

    public static class InputWindowElement {
        public List<RowsPullingHandler.InputRow> rows = Lists.newArrayList();
    }

    public static class InputWindowBatch {
        public Map<String, InputWindowElement> windows = Maps.newHashMap();
    }
}

