/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterLocalKernelsMonitoringService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    Map<Integer, MonitoredSession> monitoredSessions = new HashMap<Integer, MonitoredSession>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.resourceusage.jupyter");

    @PostConstruct
    public void init() {
        Thread t = new Thread(){

            @Override
            public void run() {
                this.setName("jupyter-kernels-monitors-watcher-" + this.getId());
                int pidsWatchingInterval = ApplicationConfigurator.getParams().getIntParam("dku.resourceusage.jupyter.localKernelsWatchInterval", Integer.valueOf(60000));
                try {
                    while (true) {
                        Thread.sleep(pidsWatchingInterval);
                        logger.debug((Object)"Updating monitoring of the local Jupyter Kernels");
                        JupyterLocalKernelsMonitoringService.this.update();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Jupyter Kernel watcher was interrupted", (Throwable)e);
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void update() throws InterruptedException {
        HashMap<Integer, JupyterUtils.ActiveSession> currentlyKnownPids = new HashMap<Integer, JupyterUtils.ActiveSession>();
        for (JupyterUtils.ActiveSession activeSession : this.jupyterService.listActiveSessions()) {
            if (activeSession.kernelPid == null) continue;
            currentlyKnownPids.put(activeSession.kernelPid, activeSession);
        }
        ArrayList<MonitoredSession> toDelete = new ArrayList<MonitoredSession>();
        for (Map.Entry<Integer, MonitoredSession> entry : this.monitoredSessions.entrySet()) {
            if (currentlyKnownPids.containsKey(entry.getKey())) {
                logger.trace((Object)("Still monitoring pid: " + String.valueOf(entry.getKey())));
                continue;
            }
            logger.debug((Object)("pid " + String.valueOf(entry.getKey()) + " not found anymore, will stop monitoring it"));
            toDelete.add(entry.getValue());
        }
        for (Map.Entry<Integer, MonitoredSession> entry : currentlyKnownPids.entrySet()) {
            if (this.monitoredSessions.containsKey(entry.getKey())) {
                logger.trace((Object)("Already monitoring pid: " + String.valueOf(entry.getKey())));
                continue;
            }
            logger.debug((Object)("pid " + String.valueOf(entry.getKey()) + " appeared, starting monitoring"));
            try {
                final MonitoredSession ms = new MonitoredSession();
                ms.session = (JupyterUtils.ActiveSession)((Object)entry.getValue());
                ms.pid = entry.getKey();
                AuthCtx authCtx = null;
                try (Transaction t = this.transactionService.beginRead();){
                    authCtx = this.authCtxCreationService.create(ms.session.sessionCreator);
                }
                ms.cru = new ComputeResourceUsage();
                ms.cru.context = ComputeResourceUsageContext.forJupyterNotebookKernel((AuthCtx)authCtx, (String)ms.session.projectKey, (String)ms.session.notebookName, (String)ms.session.sessionId);
                ms.cru.setupLocalProcess();
                ms.monitor = new ProcessResourceUsageMonitor(ms.cru, "kernel", new WithMaybePid(){

                    public int getPidIfAvailable() {
                        return ms.pid;
                    }
                });
                ms.monitor.start();
                logger.info((Object)("Local Jupyter kernel monitoring started for pid " + ms.pid));
                this.monitoredSessions.put(ms.pid, ms);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to start monitoring for pid " + String.valueOf(entry.getKey())), (Throwable)e);
            }
        }
        for (MonitoredSession monitoredSession : toDelete) {
            logger.info((Object)("Finishing and reporting local Jupyter kernel monitoring for old pid " + monitoredSession.pid));
            try {
                monitoredSession.monitor.finish(true);
                monitoredSession.cru.reportCompleteNoFail();
                this.monitoredSessions.remove(monitoredSession.pid);
            }
            catch (InterruptedException e) {
                logger.warn((Object)("Failed to stop monitoring for pid " + monitoredSession.pid), (Throwable)e);
                throw e;
            }
        }
        logger.info((Object)("List of monitored pids: " + this.monitoredSessions.values().stream().map(s -> "" + s.pid).collect(Collectors.joining(","))));
    }

    static class MonitoredSession {
        ComputeResourceUsage cru;
        JupyterUtils.ActiveSession session;
        ProcessResourceUsageMonitor monitor;
        int pid;

        MonitoredSession() {
        }
    }
}

