/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;

public class SQLComputeResourceUsage {
    private static final long UPDATE_INTERVAL = DKUApp.getParams().getLongParam("dku.cru.sql.insertUpdateIntervalMS", 60000L);

    public static ComputeResourceUsage.UpdateChecking getUpdateChecking() {
        return new ComputeResourceUsage.UpdateChecking(UPDATE_INTERVAL);
    }

    public static ComputeResourceUsage startSQLQuery(SQLConnectionProvider.SQLConnectionWrapper connectionWrapper, String query, boolean reportCRU) {
        if (!reportCRU) {
            return new ComputeResourceUsage(true);
        }
        ComputeResourceUsage cru = new ComputeResourceUsage();
        SQLComputeResourceUsage.setupSQLQuery(cru, connectionWrapper, query);
        return cru;
    }

    public static ComputeResourceUsage forSQLQuery(SQLConnectionProvider.SQLConnectionWrapper connectionWrapper, String query) {
        ComputeResourceUsage cru = new ComputeResourceUsage();
        SQLComputeResourceUsage.setupSQLQuery(cru, connectionWrapper, query);
        return cru;
    }

    public static void setupSQLQuery(ComputeResourceUsage cru, SQLConnectionProvider.SQLConnectionWrapper connectionWrapper, String query) {
        ComputeResourceUsage pooledCRU = connectionWrapper.getComputeResourceUsage();
        String sparkSQLConnectionUsageId = connectionWrapper instanceof SparkSQLConnectionPoolService.SparkSQLConnection && pooledCRU != null ? pooledCRU.id : null;
        cru.setupSQLQuery(pooledCRU != null ? pooledCRU.id : null, connectionWrapper.getConnectionData().getConnection().name, sparkSQLConnectionUsageId, query);
    }

    public static void setupSQLConnection(ComputeResourceUsage cru, SQLConnectionProvider.SQLConnectionWrapper connectionWrapper, String connectionName) {
        ComputeResourceUsage pooledCRU = connectionWrapper.getComputeResourceUsage();
        String sparkSQLConnectionUsageId = connectionWrapper instanceof SparkSQLConnectionPoolService.SparkSQLConnection && pooledCRU != null ? pooledCRU.id : null;
        cru.setupSQLConnection(connectionName, sparkSQLConnectionUsageId);
    }
}

