/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.agents;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentDesc;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomAgentsService
extends AbstractElementService<CustomAgentDesc, LoadedCustomAgent> {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.genai.agents.plugins");

    @Override
    public String getFolderName() {
        return "python-agents";
    }

    @Override
    public String getPrefix() {
        return "agent";
    }

    @Override
    protected String getCodeExtension(LoadedCustomAgent desc) {
        return "";
    }

    @Override
    public Class<CustomAgentDesc> getDescClass() {
        return CustomAgentDesc.class;
    }

    @Override
    public Class<LoadedCustomAgent> getLoadedDescClass() {
        return LoadedCustomAgent.class;
    }

    @Override
    protected void removeElement(LoadedCustomAgent desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "agent_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomAgent load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomAgentDesc desc = (CustomAgentDesc)JSON.parseFile((File)file, CustomAgentDesc.class);
        desc.id = elementType;
        LoadedCustomAgent loaded = new LoadedCustomAgent(elementType, pluginId, elementId, desc);
        CustomAgentMeta stepMeta = new CustomAgentMeta(loaded);
        AgentTypesRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomAgentDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomAgentsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    public String getPythonLibFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        LoadedCustomAgent loadedDesc = (LoadedCustomAgent)this.loadedDescs.get(elementType);
        File libDir = this.pluginsService.getPluginPythonlibFolder(loadedDesc.getOwnerPluginId());
        return libDir.getAbsolutePath();
    }
}

