/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.ContextAwareTicketPayload;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ScenarioRun
extends ScenarioRunKey
implements ContextAwareTicketPayload {
    public long start;
    public TriggerFire trigger;
    public long end;
    public ReportItem result;
    public transient ReportItem.Outcome currentOutcome;
    public DSSAuthCtx runAsUser;
    public JsonObject variables = new JsonObject();
    public List<SimpleKeyValue> clustersUsed = Lists.newArrayList();
    public transient String clusterIdOverride;
    public transient String k8sClusterIdOverride;
    @Nullable
    public String bundleId;
    public boolean markedAsTest;
    public List<ReporterState> reportersStates = new ArrayList<ReporterState>();
    public transient Map<String, Object> stepRunOutputs = Maps.newHashMap();

    public ScenarioRun() {
    }

    public ScenarioRun(ScenarioRun src) {
        super(src);
        this.start = src.getStart();
        this.trigger = src.getTrigger();
        this.end = src.getEnd();
        this.result = src.getResult();
        this.runAsUser = src.getRunAsUser();
        this.variables = (JsonObject)JSON.deepCopy((Object)src.getVariables());
    }

    public AutoCloseable openTicketContext() {
        return new AutoCloseable(){
            private final ScenarioRun previousScenarioRun;
            private ScenarioRunContext scenarioRunContext = (ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class);
            {
                this.previousScenarioRun = this.scenarioRunContext.getScenarioRun();
                this.scenarioRunContext.setScenarioRun(ScenarioRun.this);
            }

            @Override
            public void close() {
                this.scenarioRunContext.setScenarioRun(this.previousScenarioRun);
            }
        };
    }

    public TriggerFire getTrigger() {
        return this.trigger;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public ReportItem getResult() {
        return this.result;
    }

    public DSSAuthCtx getRunAsUser() {
        return this.runAsUser;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public Map<String, Object> getStepRunOutputs() {
        return Maps.newHashMap(this.stepRunOutputs);
    }

    public ReportItem.Outcome getCurrentOutcome() {
        if (this.result != null && this.result.getOutcome() != null) {
            return this.result.getOutcome();
        }
        if (this.currentOutcome != null) {
            return this.currentOutcome;
        }
        return null;
    }

    public boolean isMarkedAsTest() {
        return this.markedAsTest;
    }

    public ScenarioRun withTrigger(TriggerFire trigger) {
        this.trigger = trigger;
        return this;
    }

    public ScenarioRun withStart(long start) {
        this.start = start;
        return this;
    }

    public ScenarioRun withEnd(long end) {
        this.end = end;
        return this;
    }

    public ScenarioRun withResult(ReportItem result) {
        this.result = result;
        return this;
    }

    public ScenarioRun withRunAsUser(DSSAuthCtx runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public ScenarioRun withVariables(JsonObject variables) {
        this.variables = variables;
        return this;
    }

    public ScenarioRun withStringVariable(String key, String value) {
        this.variables.addProperty(key, value);
        return this;
    }

    public ScenarioRun withStepRunOutput(StepRun stepRun, Object output) {
        this.stepRunOutputs.put(stepRun.getRunId(), output);
        return this;
    }

    public ScenarioRun withCurrentOutcome(ReportItem.Outcome outcome) {
        this.currentOutcome = outcome;
        return this;
    }

    public ScenarioRun withBundleId(String bundleId) {
        this.bundleId = bundleId;
        return this;
    }

    public ScenarioRun withMarkedAsTest(boolean markedAsTest) {
        this.markedAsTest = markedAsTest;
        return this;
    }

    public synchronized List<SimpleKeyValue> getClustersUsed() {
        return Lists.newArrayList(this.clustersUsed);
    }

    public synchronized void addClusterUsed(SimpleKeyValue clusterUsed) {
        this.clustersUsed.add(clusterUsed);
    }

    public synchronized void removeClustersUsed(List<SimpleKeyValue> toRemove) {
        this.clustersUsed.removeAll(toRemove);
    }

    public static class ReporterState {
        public String reporterName;
        public String messagingType;
        public boolean activated;
        public SerializedError error;
        public InfoMessage.InfoMessages messages;
        public long started;
        public long ended;
    }
}

