/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.testing;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class JunitXmlReport {
    private JunitXmlReport() {
        throw new IllegalStateException("Utility class");
    }

    public static class Failure {
        @JacksonXmlProperty(isAttribute=true)
        public String message;
        @JacksonXmlProperty(isAttribute=true)
        public String type;
        @JacksonXmlText
        public String text;

        public Failure(String message, String type, String text) {
            this.message = message;
            this.type = type;
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure = (Failure)o;
            return Objects.equals(this.message, failure.message) && Objects.equals(this.type, failure.type) && Objects.equals(this.text, failure.text);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.type, this.text);
        }
    }

    public static class TestCase {
        @JacksonXmlProperty(isAttribute=true)
        public String name;
        @JacksonXmlProperty(isAttribute=true)
        public double time;
        @Nullable
        public Failure failure;

        public TestCase(String name, double time, @Nullable Failure failure) {
            this.name = name;
            this.time = time;
            this.failure = failure;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestCase testCase = (TestCase)o;
            return Double.compare(this.time, testCase.time) == 0 && Objects.equals(this.name, testCase.name) && Objects.equals(this.failure, testCase.failure);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.time, this.failure);
        }
    }

    public static class TestSuite {
        @JacksonXmlProperty(isAttribute=true)
        public String name;
        @JacksonXmlProperty(isAttribute=true)
        public int tests;
        @JacksonXmlProperty(isAttribute=true)
        public int failures;
        @JacksonXmlProperty(isAttribute=true)
        public int errors;
        @JacksonXmlProperty(isAttribute=true)
        public int skipped;
        @JacksonXmlProperty(isAttribute=true)
        public double time;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="testcase")
        public List<TestCase> testCases;

        public TestSuite(String name, int tests, int failures, int errors, int skipped, double time, List<TestCase> testCases) {
            this.name = name;
            this.tests = tests;
            this.failures = failures;
            this.errors = errors;
            this.skipped = skipped;
            this.time = time;
            this.testCases = testCases;
        }
    }

    @JacksonXmlRootElement(localName="testsuites")
    public static class TestSuites {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="testsuite")
        public List<TestSuite> testSuites;

        public TestSuites(List<TestSuite> testSuites) {
            this.testSuites = testSuites;
        }
    }
}

