/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.scheduler.steps.LoadedPythonPluginStep;
import com.dataiku.dip.scheduler.steps.PythonPluginStepDesc;
import com.dataiku.dip.scheduler.steps.PythonPluginStepRunner;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class PythonPluginStepsService
extends CustomPythonElementService<PythonPluginStepDesc, LoadedPythonPluginStep> {
    @Override
    public String getFolderName() {
        return "python-steps";
    }

    @Override
    public String getPrefix() {
        return "step";
    }

    @Override
    protected String getCodeExtension(LoadedPythonPluginStep desc) {
        return ".py";
    }

    @Override
    public Class<PythonPluginStepDesc> getDescClass() {
        return PythonPluginStepDesc.class;
    }

    @Override
    public Class<LoadedPythonPluginStep> getLoadedDescClass() {
        return LoadedPythonPluginStep.class;
    }

    @Override
    protected void removeElement(LoadedPythonPluginStep desc) {
        StepRegistry.deregister(desc.stepType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "pystep_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonPluginStep load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonPluginStep loaded = new LoadedPythonPluginStep(elementId, pluginId, elementType, (PythonPluginStepDesc)JSON.parseFile((File)file, PythonPluginStepDesc.class));
        PythonPluginStepRunner.PythonPluginStepMeta stepMeta = new PythonPluginStepRunner.PythonPluginStepMeta(pluginId, loaded, this);
        StepRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonPluginStepDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PythonPluginStepsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

