/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.scheduler.triggers.SQLQueryTriggerRunner;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class SQLQueryTriggerState {
    private String paramsHash;
    private int rowCount;
    private String rowsHash;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.trigger.sql");

    public SQLQueryTriggerState(String paramsHash, int rowCount, String rowsHash) {
        this.paramsHash = paramsHash;
        this.rowCount = rowCount;
        this.rowsHash = rowsHash;
    }

    public SQLQueryTriggerState(ResultSet resultSet, SQLDialect dialect, SQLQueryTriggerRunner.SQLQueryTriggerParams params) throws SQLException, InterruptedException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Schema schema = SchemaReader.metadataToSchema(dialect, metaData, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
        MessageDigest md5 = DigestUtils.getMd5Digest();
        int currentRowNumber = 0;
        md5.update(StringUtils.getBytesUtf8((String)"["));
        boolean firstLine = true;
        while (true) {
            if (!resultSet.next()) {
                logger.info((Object)("Result set has no more rows (returned " + currentRowNumber + ")."));
                break;
            }
            if (currentRowNumber >= params.getLimit()) {
                logger.info((Object)("Result set has more than " + params.getLimit() + " rows. Stop the computation."));
                break;
            }
            if (currentRowNumber % 1000 == 0) {
                logger.info((Object)("Enumerated " + currentRowNumber + " rows."));
                FutureProgressState.checkInterrupt();
            }
            if (!firstLine) {
                md5.update(StringUtils.getBytesUtf8((String)","));
            } else {
                firstLine = false;
            }
            String[] row = new String[metaData.getColumnCount()];
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                row[i - 1] = dialect.getValueAsDSSString(resultSet, metaData.getColumnType(i), i, (SchemaColumn)schema.columns.get(i - 1), true, false, DateTimeZone.UTC);
            }
            md5.update(StringUtils.getBytesUtf8((String)JSON.json((Object)row)));
            ++currentRowNumber;
        }
        md5.update(StringUtils.getBytesUtf8((String)"]"));
        this.paramsHash = DKUtils.md5Base64((String)JSON.json((Object)params));
        this.rowCount = currentRowNumber;
        this.rowsHash = Base64.encodeBase64String((byte[])md5.digest()).substring(0, 22);
    }

    public String getParamsHash() {
        return this.paramsHash;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getRowsHash() {
        return this.rowsHash;
    }

    public String toString() {
        return "SQLQueryTriggerState{paramsHash=\"" + this.paramsHash + "\", rowCount=" + this.rowCount + ", rowsHash=\"" + this.rowsHash + "\"}";
    }
}

