/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring;

import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.scoring.Try;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.builders.ObservationBuilder;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationResult;
import com.dataiku.scoring.pipelines.Coercion;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import com.dataiku.scoring.pipelines.RegressionResult;
import com.dataiku.scoring.util.RawObservation;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class Predictor {
    private final RawPredictor rawPredictor;
    private final Coercion coercion;
    private final Normalization normalization;

    public Predictor(File modelFolder) throws IOException {
        URL modelURL = modelFolder.toURI().toURL();
        Build.DssPipelineMeta meta = Build.pipelineMeta((URL)modelURL);
        this.coercion = Build.coercion((URL)modelURL);
        this.normalization = Build.normalization((URL)modelURL, (Build.DssPipelineMeta)meta);
        switch (meta.type) {
            case REGRESSION: {
                this.rawPredictor = new RegressionPredictor(Build.regressionPipeline((URL)modelURL, (Build.DssPipelineMeta)meta));
                break;
            }
            case CLASSIFICATION_ONLY: {
                this.rawPredictor = new ClassificationPredictor(Build.nonProbabilisticClassificationPipeline((URL)modelURL, (Build.DssPipelineMeta)meta));
                break;
            }
            case BINARY_PROBABILISTIC: {
                this.rawPredictor = new BinaryProbabilisticPredictor(Build.binaryProbabilisticPipeline((URL)modelURL, (Build.DssPipelineMeta)meta));
                break;
            }
            case MULTICLASS_PROBABILISTIC: {
                this.rawPredictor = new MulticlassProbabilisticPredictor(Build.multiclassProbabilisticPipeline((URL)modelURL, (Build.DssPipelineMeta)meta));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type : " + String.valueOf(meta.type));
            }
        }
    }

    public ObservationBuilder.NormalizingCoercingBuilder getNormalizingCoercingBuilder() {
        return new ObservationBuilder.NormalizingCoercingBuilder(this.coercion, this.normalization);
    }

    public PredictionResponse.PredictionResponseItem predict(RawObservation s) {
        return this.rawPredictor.predict(s);
    }

    class RegressionPredictor
    implements RawPredictor {
        private final RegressionPipeline pipe;

        RegressionPredictor(RegressionPipeline pipe) {
            this.pipe = pipe;
        }

        @Override
        public PredictionResponse.PredictionResponseItem predict(RawObservation s) {
            Try tryResult = this.pipe.getPredictionResults(s);
            PredictionResponse.RegressionResponseItem item = new PredictionResponse.RegressionResponseItem();
            if (tryResult.isSuccess()) {
                RegressionResult result = (RegressionResult)tryResult.get();
                if (result.isDeclined()) {
                    item.ignored = true;
                    item.ignoreReason = PredictionResponse.IgnoreReason.PREDICTION_DECLINED;
                } else {
                    item.ignored = false;
                    item.prediction = (Double)result.getPrediction();
                }
                if (result.hasOverrideInfo()) {
                    item.override = result.overrideInfo;
                }
                result.getPredictionInterval().ifPresent(interval -> {
                    item.predictionIntervalLower = interval.lower;
                    item.predictionIntervalUpper = interval.upper;
                });
            } else {
                item.ignored = true;
                item.ignoreReason = PredictionResponse.IgnoreReason.IGNORED_BY_MODEL;
            }
            return item;
        }
    }

    public static interface RawPredictor {
        public PredictionResponse.PredictionResponseItem predict(RawObservation var1);
    }

    class ClassificationPredictor
    implements RawPredictor {
        private final NonProbabilisticClassificationPipeline pipe;

        ClassificationPredictor(NonProbabilisticClassificationPipeline pipe) {
            this.pipe = pipe;
        }

        @Override
        public PredictionResponse.PredictionResponseItem predict(RawObservation s) {
            Try tryResult = this.pipe.getPredictionResults(s);
            PredictionResponse.ClassificationResponseItem item = new PredictionResponse.ClassificationResponseItem();
            if (tryResult.isSuccess()) {
                NonProbabilisticClassificationResult result = (NonProbabilisticClassificationResult)tryResult.get();
                if (result.isDeclined()) {
                    item.ignored = true;
                    item.ignoreReason = PredictionResponse.IgnoreReason.PREDICTION_DECLINED;
                } else {
                    item.ignored = false;
                    item.prediction = (String)result.getPrediction();
                }
                if (result.hasOverrideInfo()) {
                    item.override = result.overrideInfo;
                }
            } else {
                item.ignored = true;
                item.ignoreReason = PredictionResponse.IgnoreReason.IGNORED_BY_MODEL;
            }
            return item;
        }
    }

    class BinaryProbabilisticPredictor
    implements RawPredictor {
        private final BinaryProbabilisticPipeline pipe;

        BinaryProbabilisticPredictor(BinaryProbabilisticPipeline pipe) {
            this.pipe = pipe;
        }

        @Override
        public PredictionResponse.PredictionResponseItem predict(RawObservation s) {
            Try tryResult = this.pipe.getPredictionResults(s);
            PredictionResponse.ClassificationResponseItem item = new PredictionResponse.ClassificationResponseItem();
            if (tryResult.isSuccess()) {
                ClassificationResult result = (ClassificationResult)tryResult.get();
                if (result.isDeclined()) {
                    item.ignored = true;
                    item.ignoreReason = PredictionResponse.IgnoreReason.PREDICTION_DECLINED;
                } else {
                    item.ignored = false;
                    item.prediction = (String)result.getPrediction();
                    item.probas = this.pipe.remapProbabilities(result);
                    Try percentile = this.pipe.getProbaPercentile(result);
                    if (percentile.isSuccess()) {
                        item.probaPercentile = (Short)percentile.get();
                    }
                }
                if (result.hasOverrideInfo()) {
                    item.override = result.overrideInfo;
                }
            } else {
                item.ignored = true;
                item.ignoreReason = PredictionResponse.IgnoreReason.IGNORED_BY_MODEL;
            }
            return item;
        }
    }

    class MulticlassProbabilisticPredictor
    implements RawPredictor {
        private final MulticlassProbabilisticPipeline pipe;

        MulticlassProbabilisticPredictor(MulticlassProbabilisticPipeline pipe) {
            this.pipe = pipe;
        }

        @Override
        public PredictionResponse.PredictionResponseItem predict(RawObservation s) {
            Try tryResult = this.pipe.getPredictionResults(s);
            PredictionResponse.ClassificationResponseItem item = new PredictionResponse.ClassificationResponseItem();
            if (tryResult.isSuccess()) {
                ClassificationResult result = (ClassificationResult)tryResult.get();
                if (result.isDeclined()) {
                    item.ignored = true;
                    item.ignoreReason = PredictionResponse.IgnoreReason.PREDICTION_DECLINED;
                } else {
                    item.ignored = false;
                    item.prediction = (String)result.getPrediction();
                    item.probas = this.pipe.remapProbabilities(result);
                }
                if (result.hasOverrideInfo()) {
                    item.override = result.overrideInfo;
                }
            } else {
                item.ignored = true;
                item.ignoreReason = PredictionResponse.IgnoreReason.IGNORED_BY_MODEL;
            }
            return item;
        }
    }
}

