/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml;

import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.scoring.exports.pmml.PMMLPreprocessing;
import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLDataDictionary;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLHeader;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLTransformationDictionary;
import com.dataiku.dip.scoring.exports.pmml.models.PMMLModel;
import com.dataiku.dip.scoring.exports.pmml.models.classification.PMMLClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.regression.PMMLRegressor;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

@XML.Named(name="PMML")
public class PMML {
    @XML.Attribute
    public final String version = "4.2";
    @XML.Attribute
    public final String xmlns = "http://www.dmg.org/PMML-4_2";
    public XML.CustomAttribute xmlnsXsi = new XML.CustomAttribute(){

        @Override
        public String getName() {
            return "xmlns:xsi";
        }

        @Override
        public String getValue() {
            return "http://www.w3.org/2001/XMLSchema-instance";
        }
    };
    public XML.CustomAttribute xsiSchemaLoc = new XML.CustomAttribute(){

        @Override
        public String getName() {
            return "xsi:schemaLocation";
        }

        @Override
        public String getValue() {
            return "http://www.dmg.org/PMML-4_2 http://www.dmg.org/v4-2/pmml-4-2.xsd";
        }
    };
    @XML.Element
    public PMMLHeader Header;
    @XML.Element
    public PMMLDataDictionary DataDictionary;
    @XML.Element
    public PMMLTransformationDictionary TransformationDictionary;
    @XML.Element
    public PMMLModel model;

    public static PMML fromModelResources(File resources) throws IOException, CodedException {
        PMML pmml;
        Build.DssPipelineMeta meta = null;
        File metaFile = new File(resources, "dss_pipeline_meta.json");
        if (!metaFile.isFile()) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INCOMPATIBLE_MODEL_ENGINE, "Model meta file does not exist, model is probably not PMML-compatible");
        }
        meta = (Build.DssPipelineMeta)JSON.parseFile((File)metaFile, Build.DssPipelineMeta.class);
        if (meta == null || meta.type == null) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INCOMPATIBLE_MODEL_ENGINE, "Model is not PMML-compatible");
        }
        if (meta.partitioning != null) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INCOMPATIBLE_MODEL_ENGINE, "Partitioned Model is not PMML-compatible");
        }
        ResolvedClassicalPredictionPreprocessingParams rppp = (ResolvedClassicalPredictionPreprocessingParams)JSON.parseFile((File)new File(resources, "rpreprocessing_params.json"), ResolvedClassicalPredictionPreprocessingParams.class);
        PreTrainPredictionModelingParams rpmp = (PreTrainPredictionModelingParams)JSON.parseFile((File)new File(resources, "rmodeling_params.json"), PreTrainPredictionModelingParams.class);
        Normalization normalization = Build.normalization((URL)resources.toURI().toURL(), (Build.DssPipelineMeta)meta);
        Map actions = normalization.actions;
        switch (meta.type) {
            case REGRESSION: {
                RegressionPipeline pipe = Build.regressionPipeline((URL)resources.toURI().toURL(), (Build.DssPipelineMeta)meta);
                pmml = PMML.fromRegressionPipeline(pipe, rppp, actions);
                pmml.Header.description = String.valueOf(pipe.getModel().getClass()) + " regression model";
                break;
            }
            case BINARY_PROBABILISTIC: {
                BinaryProbabilisticPipeline pipe = Build.binaryProbabilisticPipeline((URL)resources.toURI().toURL(), (Build.DssPipelineMeta)meta);
                pmml = PMML.fromClassificationPipeline((ClassificationPipeline)pipe, rppp, actions);
                pmml.Header.description = String.valueOf(pipe.getModel().getClass()) + " binary classification model";
                break;
            }
            case MULTICLASS_PROBABILISTIC: {
                MulticlassProbabilisticPipeline pipe = Build.multiclassProbabilisticPipeline((URL)resources.toURI().toURL(), (Build.DssPipelineMeta)meta);
                pmml = PMML.fromClassificationPipeline((ClassificationPipeline)pipe, rppp, actions);
                pmml.Header.description = String.valueOf(pipe.getModel().getClass()) + " classification model";
                break;
            }
            case CLASSIFICATION_ONLY: {
                throw new NotImplementedException("PMML export of non-probabilistic classification models is not supported");
            }
            default: {
                throw new IllegalStateException("Unexpected pipeline type: " + String.valueOf(meta.type));
            }
        }
        return pmml;
    }

    public static PMML fromRegressionPipeline(RegressionPipeline pipe, ResolvedPredictionPreprocessingParams rppp, Map<String, Normalization.Action> actions) {
        PMML doc = new PMML();
        doc.Header = new PMMLHeader();
        doc.DataDictionary = PMMLDataDictionary.build(pipe.getPreprocessing(), rppp);
        boolean castToFloat = !pipe.getModel().expectsProcessedFeaturesAsDoubles();
        doc.TransformationDictionary = PMMLTransformationDictionary.fromPreprocessing(pipe.getPreprocessing(), actions, castToFloat);
        PMMLRegressor pmmlRegressor = PMMLRegressor.fromRegressionPipeline(pipe, rppp);
        String[] colNames = PMMLPreprocessing.normalizedOutputColumns(pipe.getPreprocessing().getOutputColumns(), pipe.getPreprocessing());
        pmmlRegressor.enrichTransformationDictionaryFromModel(doc.TransformationDictionary, colNames, pipe.getModel());
        doc.model = pmmlRegressor;
        return doc;
    }

    public static PMML fromClassificationPipeline(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp, Map<String, Normalization.Action> actions) {
        PMML doc = new PMML();
        doc.Header = new PMMLHeader();
        doc.DataDictionary = PMMLDataDictionary.build(pipe.getPreprocessing(), rppp);
        boolean castToFloat = !pipe.getModel().expectsProcessedFeaturesAsDoubles();
        doc.TransformationDictionary = PMMLTransformationDictionary.fromPreprocessing(pipe.getPreprocessing(), actions, castToFloat);
        PMMLClassifier pmmlClassifier = PMMLClassifier.fromClassificationPipeline(pipe, rppp);
        String[] colNames = PMMLPreprocessing.normalizedOutputColumns(pipe.getPreprocessing().getOutputColumns(), pipe.getPreprocessing());
        pmmlClassifier.enrichTransformationDictionaryFromModel(doc.TransformationDictionary, colNames, pipe.getModel());
        doc.model = pmmlClassifier;
        return doc;
    }

    public Document toDocument() throws Exception {
        return XML.toDocument(this);
    }

    public void writeToStream(OutputStream os) throws Exception {
        Document doc = this.toDocument();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
    }
}

