/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.apideployer;

import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.deployments.AbstractDeploymentsService;
import com.dataiku.dip.apideployer.deployments.actions.DeploymentActionsService;
import com.dataiku.dip.apideployer.deployments.actions.updates.DeploymentUpdateService;
import com.dataiku.dip.apideployer.engine.DeploymentHooksService;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.published.AbstractPublishedItemsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

abstract class AbstractDeployerController<D extends AbstractDeployment, I extends AbstractPublishedItemBasicInfo, N extends AbstractDeploymentInfra>
extends DIPInternalControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private DeploymentHooksService deploymentHooksService;
    @Autowired
    private DeploymentActionsService deploymentActionsService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private DeploymentUpdateService deploymentUpdateService;
    private final String deploymentType;
    private String publishedItemType;

    abstract AbstractDeploymentsService<D, I, N> getDeploymentsService();

    abstract AbstractPublishedItemsService<D, I, N> getPublishedItemsService();

    abstract AbstractInfrasService<D, I, N> getInfrasService();

    abstract boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus var1);

    void checkLicense() throws LicenseRestrictionException {
        LicenseStatusService.LicensingStatus licenseStatus = this.licenseStatusService.getLicensingStatus();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures = this.licenseEnforcementService.getFeaturesStatus();
        if (!this.hasLicenseFlag(licenseFeatures) && !licenseStatus.ceEntrepriseTrial) {
            throw new LicenseRestrictionException(this.deploymentType + " deployer is not available in your license");
        }
    }

    void checkProjectStandardsLicense() throws LicenseRestrictionException {
        LicenseStatusService.LicensingStatus licenseStatus = this.licenseStatusService.getLicensingStatus();
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures = this.licenseEnforcementService.getFeaturesStatus();
        if (!licenseFeatures.projectStandardsAllowed) {
            throw new LicenseRestrictionException("Project Standards is not available in your license");
        }
    }

    AbstractDeployerController(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    @PostConstruct
    public void init() {
        this.publishedItemType = this.getPublishedItemsService().getType();
    }

    void listPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, this.getPublishedItemsService().listLightStatusUnsafe_NT_Check(user));
    }

    void listPublishedBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        AbstractPublishedItemBasicInfo.PublishedItemBasicInfoList<I> list = this.getPublishedItemsService().createItemBasicInfoList();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            list.setItems(this.getPublishedItemsService().listPublishedItemBasicInfoUnsafe_Check(authCtx));
        }
        for (AbstractPublishedItemBasicInfo basicInfo : list.getItems()) {
            for (PublishedPackageInfo v : this.getPublishedItemsService().listPublishedPackages_Check_Unsafe_NT(basicInfo.id, authCtx)) {
                basicInfo.addPackageId(v.id);
            }
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, list);
    }

    void getPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp, String itemId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getPublishedItemsService().getPublishedItemLightStatusUnsafe_NT_Check(itemId, user));
    }

    void getPublishedSettings(HttpServletRequest req, HttpServletResponse resp, String itemId) throws Exception {
        PublishedItem item;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            item = this.getPublishedItemsService().getPublishedItemSettingsMandatoryUnsafe_Check(itemId, user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)item);
    }

    void getLogsList(HttpServletRequest req, HttpServletResponse resp, String id) throws Exception {
        List<LogsService.LogDesc> logs;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            logs = this.getDeploymentsService().getLogsList_Check(id, user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, logs);
    }

    void getLog(HttpServletRequest req, HttpServletResponse resp, String id, String logName) throws Exception {
        SmartLogTail log;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            log = this.getDeploymentsService().getLog_Check(id, logName, user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)log);
    }

    void streamLog(HttpServletRequest req, HttpServletResponse resp, String id, String logName) throws Exception {
        D depl;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            depl = this.getDeploymentsService().streamLog_Check(id, user);
        }
        this.getDeploymentsService().streamLog(depl, logName, (OutputStream)resp.getOutputStream());
    }

    public void getAllLogsZip(HttpServletRequest req, HttpServletResponse resp, String id) throws Exception {
        D depl;
        String dlName = id + "-logs.zip";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.authService.failIfNotAdmin(user);
            depl = this.getDeploymentsService().streamLog_Check(id, user);
        }
        this.getDeploymentsService().getAllLogsZip(depl, (OutputStream)resp.getOutputStream());
    }

    void getLastDeploymentAction(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().getLastDeploymentAction_Check(deploymentId, user));
        }
    }

    void getDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, String deploymentId, String startTimestamp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().getDeploymentUpdate_Check_NT(deploymentId, startTimestamp, authCtx));
    }

    void listDeploymentUpdateHeads(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, this.getDeploymentsService().listDeploymentUpdateHeads_Check_NT(deploymentId, authCtx));
    }

    void getUpdateSettingsDiff(HttpServletRequest req, HttpServletResponse resp, String deploymentId, String startTimestamp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().getUpdateSettingsDiff_Check_NT(deploymentId, startTimestamp, authCtx));
    }

    void peekDeploymentActionProgress(HttpServletRequest req, HttpServletResponse resp, String deploymentId, @Nullable String jobId) throws Exception {
        N infra;
        D deployment;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUserNoXSRF(req);
            deployment = this.getDeploymentsService().getSettingsMandatory_Check(deploymentId, user);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe(((AbstractDeployment)deployment).infraId);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, this.deploymentActionsService.peekDeploymentActionProgress(user, (AbstractDeployment)deployment, (AbstractDeploymentInfra)infra, jobId));
    }

    void abortDeploymentAction(HttpServletRequest req, String deploymentId) throws Exception {
        D deployment;
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUserNoXSRF(req);
            this.getDeploymentsService().checkDeployPermissions(deploymentId, user);
            deployment = this.getDeploymentsService().getSettingsMandatory_Check(deploymentId, user);
        }
        this.deploymentActionsService.abortDeploymentAction(user, (AbstractDeployment)deployment);
    }

    void createPublished(HttpServletRequest req, HttpServletResponse resp, String itemId, String label) throws Exception {
        PublishedItem item;
        this.checkLicense();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.getPublishedItemsService().createPublishedItem_Check(itemId, label, user);
            item = this.getPublishedItemsService().getPublishedItemSettingsMandatoryUnsafe_Check(itemId, user);
            t.commitV("Created published %s: %s", new Object[]{this.publishedItemType, itemId});
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)item);
    }

    @AuditInline
    void savePublished(HttpServletRequest req, HttpServletResponse resp, String item) throws Exception {
        PublishedItem parsedItem = (PublishedItem)JSON.parse((String)item, PublishedItem.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.getPublishedItemsService().savePublishedItem_Check(parsedItem, user);
            t.commitV("Updated published %s permissions: %s", new Object[]{this.publishedItemType, parsedItem.id});
            this.auditTrailService.generic(String.format("%sdeployer-%s-save", this.deploymentType.toLowerCase(), this.publishedItemType)).with(this.publishedItemType + "Id", parsedItem.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure(String.format("%sdeployer-%s-save", this.deploymentType.toLowerCase(), this.publishedItemType), (Throwable)e).with(this.publishedItemType + "Id", parsedItem.id).emit();
            throw e;
        }
    }

    void deletePublished(HttpServletRequest req, HttpServletResponse resp, String itemId) throws Exception {
        AuthCtx user;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
        }
        this.getPublishedItemsService().deletePublishedItem_NT_Check(itemId, user);
    }

    void deletePackage(HttpServletRequest req, HttpServletResponse resp, String itemId, String versionId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.getPublishedItemsService().deletePackage_NT_Check(itemId, versionId, user);
    }

    void listInfrasLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<InfraLightStatus> infras;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            infras = this.getInfrasService().listLightStatusUnsafe_Check(user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, infras);
    }

    void checkInfraStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getInfrasService().checkInfraStatus_Check_NT(user, infraId));
    }

    void listInfrasBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AbstractInfraBasicInfo.DeploymentInfraBasicInfoList list = new AbstractInfraBasicInfo.DeploymentInfraBasicInfoList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            list.infras = this.getInfrasService().listBasicInfoUnsafe_Check(user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)list);
    }

    void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        InfraLightStatus infra;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            infra = this.getInfrasService().getLightStatusUnsafe_Check(infraId, user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)infra);
    }

    void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        N infra;
        try (Transaction t = this.transactionService.beginRead();){
            AbstractAPIDeploymentInfra apiInfra;
            AuthCtx user = this.authService.getMandatoryUser(req);
            infra = this.getInfrasService().getSettingsMandatoryUnsafe_CheckAdminAndHooks(infraId, user);
            if (infra instanceof AbstractAPIDeploymentInfra && (apiInfra = (AbstractAPIDeploymentInfra)infra).getNodeLogging() != null) {
                apiInfra.getNodeLogging().checkNodesDirectoryLogManaged();
            }
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, infra);
    }

    protected abstract N getInfra(String var1);

    @AuditInline
    void saveInfra(HttpServletRequest req, HttpServletResponse resp, String infra) throws Exception {
        AuthCtx user;
        N depInfra = this.getInfra(infra);
        InfoMessage.InfoMessages report = new InfoMessage.InfoMessages();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.getInfrasService().save_Check(depInfra, user, true);
            if (user.isSafeCodeAllowed() && !StringUtils.isEmpty((String)((AbstractDeploymentInfra)depInfra).deploymentHookSettings.runHooksAsUser)) {
                this.checkHooksRunAsUser(report, depInfra, user);
            }
            t.commitV("Updated %s infra: %s", new Object[]{JSON.getType(depInfra), ((AbstractDeploymentInfra)depInfra).id});
            this.auditTrailService.generic(String.format("%sdeployer-infra-save", this.deploymentType.toLowerCase())).with("infraId", ((AbstractDeploymentInfra)depInfra).id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure(String.format("%sdeployer-infra-save", this.deploymentType.toLowerCase()), (Throwable)e).with("infraId", ((AbstractDeploymentInfra)depInfra).id).emit();
            throw e;
        }
        if (user.isSafeCodeAllowed()) {
            report.mergeFrom(this.deploymentHooksService.checkPythonCompile((AbstractDeploymentInfra)depInfra));
            AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)report);
        }
    }

    private void checkHooksRunAsUser(InfoMessage.InfoMessages report, N depInfra, AuthCtx user) throws IOException {
        try {
            this.deploymentHooksService.getHooksRunningUser_Check(user, (AbstractDeploymentInfra)depInfra);
        }
        catch (UnauthorizedException e) {
            report.withWarning((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYMENT_HOOK_RUN_AS, "The user defined to run hooks does not have the permission to run code.");
        }
    }

    void deleteInfra(HttpServletRequest req, HttpServletResponse resp, String infraId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            N infra = this.getInfrasService().getSettingsMandatoryUnsafe_CheckAdmin(infraId, user);
            this.getInfrasService().delete((AbstractDeploymentInfra)infra);
            t.commitV("Deleted %s infra: %s", new Object[]{JSON.getType(infra), infraId});
        }
    }

    void listDeploymentsTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            tags = this.getDeploymentsService().listTags();
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, tags);
    }

    void listDeploymentsBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AbstractDeploymentBasicInfo.DeploymentBasicInfoList ret = new AbstractDeploymentBasicInfo.DeploymentBasicInfoList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            ret.deployments = this.getDeploymentsService().listBasicInfoUnsafe_Check(user);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    void listDeploymentsLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, this.getDeploymentsService().listLightStatusUnsafe_NT_Check(user));
    }

    void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.getDeploymentsService().getLightStatusMandatoryUnsafe_NT_Check(deploymentId, user));
    }

    void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        D ret;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            ret = this.getDeploymentsService().getSettingsMandatory_Check(deploymentId, user);
            if (ret instanceof AbstractAPIServiceDeployment) {
                ((AbstractAPIServiceDeployment)ret).getNodeLogging().checkNodesDirectoryLogManaged();
                ((AbstractAPIServiceDeployment)ret).auth.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, ret);
    }

    @Nonnull
    protected PublishedApiServicePackageInfo getPackage(AuthCtx user, String publishedItemId, String defaultPackageVersion) throws IOException {
        List<PublishedPackageInfo> packages = this.getPublishedItemsService().listPublishedPackages_Check_Unsafe_NT(publishedItemId, user);
        if (packages.isEmpty()) {
            throw new NotFoundException("No package found in published service " + publishedItemId);
        }
        if (StringUtils.isBlank((String)defaultPackageVersion)) {
            return (PublishedApiServicePackageInfo)packages.get(packages.size() - 1);
        }
        for (PublishedPackageInfo pck : packages) {
            if (!pck.id.equals(defaultPackageVersion)) continue;
            return (PublishedApiServicePackageInfo)pck;
        }
        throw new NotFoundException("Published package not found: " + defaultPackageVersion);
    }

    void saveAndCommit(AuthCtx user, D updatedDepl, RWTransaction t) throws Exception {
        this.getDeploymentsService().save_Check(updatedDepl, user, true);
        t.commitV("Updated %s deployment: %s", new Object[]{this.deploymentType, ((AbstractDeployment)updatedDepl).id});
        this.auditTrailService.generic(String.format("%sdeployer-deployment-save", this.deploymentType.toLowerCase())).with("deploymentId", ((AbstractDeployment)updatedDepl).id).emit();
    }

    @AuditInline
    void saveDeployment(HttpServletRequest req, HttpServletResponse resp, AuthCtx user, D updatedDepl, AbstractInfraBasicInfo infraBasicInfo, String publishedItemId, List<String> versionIds) throws Exception {
        D ret;
        this.getDeploymentsService().doGovernanceCheck_NT(infraBasicInfo, publishedItemId, versionIds);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.saveAndCommit(user, updatedDepl, t);
        }
        t = this.transactionService.beginRead();
        try {
            ret = this.getDeploymentsService().getSettingsMandatory_Check(((AbstractDeployment)updatedDepl).id, user);
            if (ret instanceof AbstractAPIServiceDeployment) {
                ((AbstractAPIServiceDeployment)ret).auth.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        AbstractDeployerController.writeJSON((HttpServletResponse)resp, ret);
    }

    void switchVersion(HttpServletRequest req, HttpServletResponse resp, AuthCtx user, String deploymentId, String packageId, AbstractInfraBasicInfo infraBasicInfo, String publishedItemId) throws Exception {
        this.getDeploymentsService().doGovernanceCheck_NT(infraBasicInfo, publishedItemId, Collections.singletonList(packageId));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.getDeploymentsService().switchVersion(deploymentId, packageId, user);
            t.commitV("Switch %s of deployment %s to %s", new Object[]{this.getPublishedItemsService().getPackageType(), deploymentId, packageId});
        }
    }

    void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, String deploymentId, boolean ignorePreDeleteErrors) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        AbstractDeploymentsService.DeploymentDeletionReport ret = this.getDeploymentsService().delete_NT_Check(this.deploymentType, deploymentId, user, ignorePreDeleteErrors);
        if (ret.hasFailure()) {
            AbstractDeployerController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }
}

