/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.maintainance.InstanceInfoService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.reports.ReflectedEventsService;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.APIAuthUtilsBase;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.azure.DSSAzureADUserSupplier;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ETaggedResponseBody;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.GraphiteReportingService;
import com.dataiku.dip.server.services.HomepageContentService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.KernelGeneralSettingsService;
import com.dataiku.dip.server.services.LdapTestService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.ThemesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUpdateRunner;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.op.OIDCProviderConfigurationRequest;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.EnumUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.MalformedParametersException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConfigurationController
extends DIPInternalControllerBase {
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private MetaAuthService metaAuthService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private HomepageContentService homepageContentService;
    @Autowired
    private KernelGeneralSettingsService kernelGeneralSettingsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private LdapTestService ldapTestService;
    @Autowired
    private ThemesService themesService;
    @Autowired
    private ReportsManagementService reportsManagementService;
    @Autowired
    private ReflectedEventsService reflectedEventsService;
    @Autowired
    private InstanceInfoService instanceInfoService;
    @Autowired
    private GraphiteReportingService graphiteReportingService;
    @Autowired
    private AuditTrailService auditService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private static final Logger logger = Logger.getLogger(ConfigurationController.class);

    public void verifyPreRegistrationAuth(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.registration.preRegistrationAuthentication", false)) {
            return;
        }
        String expectedLogin = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationLogin", "");
        String expectedPass = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationPassword", "");
        APIAuthUtilsBase.BasicCredential lp = HTTPClientUtils.decodeAuth((HttpServletRequest)req);
        boolean authOK = true;
        if (lp == null || !StringUtils.isBlank((String)expectedLogin) && !expectedLogin.equals(lp.user) || !StringUtils.isBlank((String)expectedPass) && !expectedPass.equals(lp.password)) {
            authOK = false;
        }
        if (!authOK) {
            String realm = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationRealm", "DSS pre-register auth");
            resp.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            resp.sendError(401, "Authentication required");
            throw new SecurityException("Pre-authentication failed");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/ping"})
    public void ping(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("pong", Boolean.valueOf(true)).get());
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/get-translations"})
    @ETaggedResponseBody
    public ResponseEntity<Resource> getTranslations(HttpServletRequest req, HttpServletResponse resp, String location, String language) throws IOException {
        File translationsFile = this.translationService.getTranslationsFile(location, language);
        if (translationsFile == null) {
            return ResponseEntity.notFound().build();
        }
        return this.buildStreamedResponseEntity(translationsFile, MediaType.parseMediaType((String)"application/json;charset=UTF-8"));
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/save-translations"})
    public void saveTranslations(HttpServletRequest req, HttpServletResponse resp, String location, String language, String translations) throws IOException, UnauthorizedException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (!authCtx.isAdmin()) {
                throw new UnauthorizedException("Cannot save translation files", "denied");
            }
        }
        this.translationService.saveTranslationsFile(location, language, translations);
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/get-configuration"})
    @ETaggedResponseBody
    public GeneralSettingsService.AppConfig getConfiguration(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        GeneralSettingsService.AppConfig c2;
        try (Transaction t = this.transactionService.beginRead();){
            c2 = this.generalSettingsService.getConfigurationInternal(req, resp);
            if (c2.licensingMode == DKUApp.LicensingMode.NONE) {
                this.verifyPreRegistrationAuth(req, resp);
            }
            if (c2.userSettings != null && c2.userSettings.uiLanguage != null && !"en".equalsIgnoreCase(c2.userSettings.uiLanguage)) {
                c2.translations = this.translationService.getTranslations("frontend", c2.userSettings.uiLanguage);
            }
        }
        return c2;
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/get-home-articles"})
    public void getHomeArticles(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<Article> articles;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            articles = this.homepageContentService.getHomeArticles(authCtx);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, articles);
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/get-homepage-promoted-content"})
    public void getHomepagePromotedContent(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<HomepageContentService.HomepagePromotedContent> promotedContent;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            promotedContent = this.homepageContentService.getHomepagePromotedContent(authCtx);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, promotedContent);
    }

    @AuditedCall(value={"msgType", "get-promoted-content-display-names"})
    @RequestMapping(value={"/api/admin/get-promoted-content-display-names"})
    @ResponseBody
    public Map<TaggableObjectRefOrAppRef, String> getPromotedContentDisplayNames(HttpServletRequest req, @RequestParam List<TaggableObjectRefOrAppRef> taggableObjectRefs) throws Exception {
        HashMap<TaggableObjectRefOrAppRef, String> displayNamesMap = new HashMap<TaggableObjectRefOrAppRef, String>();
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            for (TaggableObjectRefOrAppRef taggableObjectRefOrAppRef : taggableObjectRefs) {
                try {
                    ITaggingService.TaggableType taggableType = null;
                    if ("APP".equals(taggableObjectRefOrAppRef.type)) {
                        displayNamesMap.put(taggableObjectRefOrAppRef, this.appsService.getAppTemplateManifest_T((String)taggableObjectRefOrAppRef.id).label);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)taggableObjectRefOrAppRef.type) || !EnumUtils.isValidEnum(ITaggingService.TaggableType.class, (String)taggableObjectRefOrAppRef.type)) continue;
                    taggableType = ITaggingService.TaggableType.valueOf(taggableObjectRefOrAppRef.type);
                    TaggableObjectsService.TaggableObjectRef taggableObjectRef = new TaggableObjectsService.TaggableObjectRef(taggableObjectRefOrAppRef.projectKey, taggableType, taggableObjectRefOrAppRef.id);
                    TaggableObjectsService.TaggableObject taggableObject = this.taggableObjectsReadService.getMandatoryUnsafe(taggableObjectRef);
                    displayNamesMap.put(taggableObjectRefOrAppRef, taggableObject.getDisplayName());
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to get display name", (Throwable)e);
                }
            }
        }
        return displayNamesMap;
    }

    @AuditedCall(value={"msgType", "dss-settings-get"})
    @RequestMapping(value={"/api/get-dss-settings", "/api/tintercom/get-dss-settings"})
    public void getDSSSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        KernelGeneralSettingsService.FeatureConfig cfg;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.metaAuthService.getFromAnyNoXSRF(req);
            if (authCtx == null) {
                throw new NotLoggedInException("No authentication found");
            }
            cfg = this.kernelGeneralSettingsService.getFeatureConfig();
        }
        catch (Exception e) {
            ConfigurationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)cfg);
    }

    @AuditedCall(value={"msgType", "admin-read-settings"})
    @RequestMapping(value={"/api/admin/get-general-settings"})
    public void getGeneralSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            RelFile f = RelFile.global((String)"general-settings.json");
            generalSettings = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
        }
        catch (Exception e) {
            ConfigurationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)generalSettings);
    }

    @AuditedCall(value={"msgType", "fetch-openid-config"})
    @RequestMapping(value={"/api/admin/fetch-openid-config"})
    public void fetchOpenIDConfig(HttpServletRequest req, HttpServletResponse resp, String wellKnownURL) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        OIDCProviderConfigurationRequest request = new OIDCProviderConfigurationRequest(new Issuer(wellKnownURL.replace("/.well-known/openid-configuration", "")));
        HTTPRequest httpRequest = request.toHTTPRequest();
        httpRequest.setProxy(ApplicationConfigurator.getProxySettings().getProxy());
        try {
            HTTPResponse httpResponse = httpRequest.send();
            resp.setStatus(httpResponse.getStatusCode());
            ConfigurationController.writeJSONString((HttpServletResponse)resp, (String)httpResponse.getContent());
        }
        catch (Exception e) {
            logger.error((Object)("Can't retrieve well known endpoint " + request.getEndpointURI().toString()), (Throwable)e);
            ConfigurationController.callFailed((Throwable)new ApplicativeException("Invalid well-known", "Can't retrieve well known endpoint " + request.getEndpointURI().toString() + ". Logs may contain more details."), (HttpServletRequest)req, (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "admin-save-settings"})
    @RequestMapping(value={"/api/admin/save-general-settings"})
    public void saveGeneralSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        GeneralSettingsChangedEvent changeEvent;
        AuthCtx authCtx;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)JSON.parse((String)data, GeneralSettingsDAO.GeneralSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            authCtx = this.authService.getMandatoryUser(req);
            changeEvent = this.generalSettingsService.save(authCtx, gs);
            t.commit("Updated general settings");
        }
        t = this.transactionService.beginRead();
        try {
            this.graphiteReportingService.restartReporterIfNeeded();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        this.generalSettingsService.checkEventServerSetting(authCtx, gs, messages);
        this.webAppsService.reloadWebAppsIfNecessary(authCtx, changeEvent, messages);
        t = this.transactionService.beginWriteForUI(req);
        try {
            boolean deleted = this.generalSettingsService.cleanupPromotedContentImages(gs);
            if (deleted) {
                t.commit("Cleaned up unused promoted content images");
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "test-welcome-email"})
    @RequestMapping(value={"/api/admin/test-welcome-email"})
    public void testWelcomeEmail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String email, @RequestParam GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings, @RequestParam GeneralSettingsDAO.NotificationsSettings notificationsSettings, @RequestParam String studioMailAddress, @RequestParam List<IntegrationChannel> integrationChannels) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        if (StringUtils.isBlank((String)email)) {
            throw new IllegalArgumentException("An email address is required");
        }
        GeneralSettingsDAO.GeneralSettings generalSettings = this.gsDAO.getUnsafeAutoTXN();
        generalSettings.welcomeEmailSettings = welcomeEmailSettings;
        generalSettings.notifications = notificationsSettings != null ? notificationsSettings : generalSettings.notifications;
        generalSettings.studioMailAddress = StringUtils.isBlank((String)studioMailAddress) ? generalSettings.studioMailAddress : studioMailAddress;
        this.usersService.testWelcomeEmail(email, generalSettings, integrationChannels);
    }

    @AuditedCall(value={"msgType", "invalidate-config-cache", "path", "${path}"})
    @RequestMapping(value={"api/admin/invalidate-config-cache"})
    public void invalidateConfigCache(HttpServletRequest req, HttpServletResponse resp, String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.transactionService.invalidateCache(RelFile.fromPath((String)path));
    }

    @AuditedCall(value={"msgType", "admin-variables-update-execute"})
    @RequestMapping(value={"/api/admin/execute-variables-update"})
    public void executeVariablesUpdate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            VariablesUpdateRunner vur = new VariablesUpdateRunner();
            vur.doUpdate((RWTransactionRef)t);
            t.commit("Executed code-based refresh of variables");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/variables/expand-expr"})
    public void expandVariable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String expr) throws Exception {
        String id;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            id = this.variablesService.getContext(projectKey).getAsString(expr);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)new Id(id));
    }

    @AuditedCall(value={"msgType", "admin-variables-read"})
    @RequestMapping(value={"/api/admin/get-global-variables"})
    public void getGlobalVariables(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String object;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            object = VariablesService.readStringUTF8ForJson5Default(new RelFile(new String[]{"variables.json"}), t);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)object);
    }

    @AuditedCall(value={"msgType", "admin-variables-save"})
    @RequestMapping(value={"/api/admin/save-global-variables"})
    public void saveGlobalVariables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            String jsonStr = data.startsWith("{") ? data : data.substring(1, data.length() - 1);
            String unescapedJsonStr = StringEscapeUtils.unescapeJson((String)jsonStr);
            try {
                JSON.parse((String)unescapedJsonStr, JsonObject.class);
            }
            catch (JsonSyntaxException e) {
                throw new MalformedParametersException("Input global variables JSON is not valid");
            }
            t.writeStringUTF8("variables.json", unescapedJsonStr);
            t.commit("Executed code-based refresh of variables");
        }
    }

    @AuditedCall(value={"msgType", "admin-get-instance-info"})
    @RequestMapping(value={"/api/admin/get-instance-info"})
    @ResponseBody
    public InstanceInfoService.InstanceInfo getInstanceInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.instanceInfoService.get(true);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pop-next-report"})
    public void getNextReport(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        ReportsManagementService.ReadyReport rr = this.reportsManagementService.popNextReport();
        if (rr == null) {
            ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)new JsonObject());
        } else {
            ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)rr.cloneWithoutPrivateInfo());
        }
    }

    @RequestMapping(value={"/api/pop-reflected-events"})
    public void popReflectedEvents(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)this.reflectedEventsService.popBatchToSend());
    }

    @AuditedCall(value={"msgType", "admin-ldap-test"})
    @RequestMapping(value={"/api/admin/test-ldap-settings"})
    public void testLdapSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        LdapTestService.LdapTestSettingsResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            LdapSettings settings = (LdapSettings)JSON.parse((String)data, LdapSettings.class);
            res = this.ldapTestService.testSettings(settings);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "admin-azure-ad-test"})
    @RequestMapping(value={"/api/admin/test-azure-ad-settings"})
    public void testAzureADSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        AzureADTestSettingsResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            TestAzureADSettings testAzureADSettings = (TestAzureADSettings)JSON.parse((String)data, TestAzureADSettings.class);
            DSSAzureADUserSupplier dssAzureADUserSupplier = new DSSAzureADUserSupplier(this.passwordEncryptionService, testAzureADSettings.azureADSettings);
            UserAttributes userAttributes = dssAzureADUserSupplier.getUserAttributes(testAzureADSettings.userIdentity);
            userAttributes.dkuGroupNames = this.userAuthenticationService.toDkuGroups(userAttributes, UserSourceType.AZURE_AD);
            res = new AzureADTestSettingsResult(userAttributes);
        }
        catch (Exception e) {
            logger.info((Object)"Testing Azure AD failed", (Throwable)e);
            res = new AzureADTestSettingsResult(new SerializedError((Throwable)e, false));
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "admin-ldap-test-user-details"})
    @RequestMapping(value={"/api/admin/test-ldap-get-user-details"})
    public void testLdapGetUserDetails(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        LdapTestService.LdapTestUserResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            LdapTestService.LdapRequest ldapRequest = (LdapTestService.LdapRequest)JSON.parse((String)data, LdapTestService.LdapRequest.class);
            res = this.ldapTestService.getUserDetails(ldapRequest);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/admin/get-themes"})
    public void getThemes(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        List<ThemesService.Theme> themes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            themes = this.themesService.list(user);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, themes);
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-keys"})
    public void getGlobalKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<GlobalScopePublicAPIKey> keys;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            keys = this.publicApiKeyService.listGlobalAPIKeys();
            keys.forEach(GlobalScopePublicAPIKey::clearManagedKeyField);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-key"})
    public void getGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws Exception {
        GlobalScopePublicAPIKey globalAPIKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyById(keyId);
            globalAPIKey.clearManagedKeyField();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)globalAPIKey));
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-key-details"})
    public void getGlobalKeyDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws IOException, DKUSecurityException {
        GlobalScopePublicAPIKey validApiKey = null;
        String decryptedKey = this.passwordEncryptionService.decryptIfEncrypted(key);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            PublicAPIKey apiKey = this.publicApiKeyService.getKey(decryptedKey);
            if (apiKey instanceof GlobalScopePublicAPIKey) {
                validApiKey = (GlobalScopePublicAPIKey)apiKey;
                validApiKey.clearManagedKeyField();
            }
        }
        if (validApiKey == null) {
            throw ErrorContext.iae((String)"Global API Key does not exist");
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)validApiKey));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/create-global-key"})
    public void createGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        GlobalScopePublicAPIKey keyObj2;
        GlobalScopePublicAPIKey keyObj = (GlobalScopePublicAPIKey)((Object)JSON.parse((String)key, GlobalScopePublicAPIKey.class));
        if (StringUtils.isBlank((String)keyObj.label)) {
            throw ErrorContext.iae((String)"API key must have a label");
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            keyObj2 = this.publicApiKeyService.createGlobalAPIKey(keyObj);
            keyObj2.clearManagedKeyField();
            t.commit("Created new public API Key, id: " + keyObj2.id);
            this.auditService.generic("admin-publicapi-key-create").with("id", keyObj2.id).emit();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)keyObj2));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/save-global-key"})
    public void saveGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        GlobalScopePublicAPIKey keyObj = (GlobalScopePublicAPIKey)((Object)JSON.parse((String)key, GlobalScopePublicAPIKey.class));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.publicApiKeyService.updateGlobalAPIKeyById(keyObj);
            t.commit("Updated public API Key, id:" + keyObj.id);
            this.auditService.generic("admin-publicapi-key-save").with("id", keyObj.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/delete-global-key"})
    public void deleteGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            GlobalScopePublicAPIKey foundKey = this.publicApiKeyService.deleteGlobalAPIKeyById(keyId);
            t.commit("Deleted public API Key, id:" + foundKey.id);
            this.auditService.generic("admin-publicapi-key-delete").with("id", foundKey.id).emit();
        }
    }

    @AuditedCall(value={"msgType", "project-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-project-api-keys"})
    public void getProjectApiKeys(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<ProjectScopePublicAPIKey> keys;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            keys = this.publicApiKeyService.listProjectAPIKeys(projectKey);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditedCall(value={"msgType", "project-read-apikey"})
    @RequestMapping(value={"/api/admin/publicapi/get-api-key-details"})
    public void getApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String secret) throws IOException, DKUSecurityException {
        PublicAPIKey validApiKey = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            PublicAPIKey apiKey = this.publicApiKeyService.getKey(secret);
            if (apiKey instanceof ProjectScopePublicAPIKey) {
                ProjectScopePublicAPIKey projectApiKey = (ProjectScopePublicAPIKey)apiKey;
                if (projectKey.equals(projectApiKey.projectKey)) {
                    validApiKey = projectApiKey;
                }
            } else if (apiKey instanceof PersonalPublicAPIKey) {
                AuthCtx ctx = this.authService.getMandatoryUser(req);
                PersonalPublicAPIKey personalPublicAPIKey = (PersonalPublicAPIKey)apiKey;
                if (personalPublicAPIKey.user.equals(ctx.getAssociatedDSSUser())) {
                    validApiKey = personalPublicAPIKey;
                }
            }
        }
        if (validApiKey == null) {
            throw ErrorContext.iae((String)("API Key does not exist or cannot be used for project " + projectKey));
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)validApiKey);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/create-project-api-key"})
    public void createProjectApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        ProjectScopePublicAPIKey keyObj2;
        ProjectScopePublicAPIKey keyObj = (ProjectScopePublicAPIKey)((Object)JSON.parse((String)key, ProjectScopePublicAPIKey.class));
        if (StringUtils.isBlank((String)keyObj.label)) {
            throw ErrorContext.iae((String)"API key must have a label");
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, keyObj.projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            keyObj2 = this.publicApiKeyService.createProjectAPIKey(keyObj);
            t.commit("Created new public API Key, id:" + keyObj2.id);
            this.auditService.generic("project-publicapi-key-create").with("id", keyObj2.id).emit();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)keyObj2));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/save-project-api-key"})
    public void saveProjectApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        ProjectScopePublicAPIKey keyObj = (ProjectScopePublicAPIKey)((Object)JSON.parse((String)key, ProjectScopePublicAPIKey.class));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, keyObj.projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            this.publicApiKeyService.updateProjectAPIKey(keyObj);
            t.commit("Updated public API Key, id: " + keyObj.id);
            this.auditService.generic("project-publicapi-key-save").with("id", keyObj.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/delete-project-api-key"})
    public void deleteProjectApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String keyId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            ProjectScopePublicAPIKey foundKey = this.publicApiKeyService.deleteProjectAPIKeyById(projectKey, keyId);
            t.commit("Deleted public API Key, id:" + foundKey.id);
            this.auditService.generic("project-publicapi-key-delete").with("id", foundKey.id).emit();
        }
    }

    @AuditedCall(value={"msgType", "user-personal-apikeys-read"})
    @RequestMapping(value={"/api/publicapi/list-personal-api-keys"})
    public void listPersonalAPIKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<PersonalPublicAPIKey> keys;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx ctx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(ctx);
            keys = this.publicApiKeyService.listMyPersonalAPIKeys(ctx);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditInline
    @RequestMapping(value={"/api/publicapi/create-personal-api-key"})
    public void createPersonalAPIKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String label, @RequestParam String description) throws Exception {
        PersonalPublicAPIKey apiKey;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.licenseEnforcementService.checkReadProjectContentAllowed(t.getUser());
            apiKey = this.publicApiKeyService.createPersonalAPIKey(t.getUser(), label, description);
            t.commit("Created personal API key for  " + t.getUser().getAssociatedDSSUser() + ", id: " + apiKey.id);
            this.auditService.generic("user-personal-apikey-create").with("id", apiKey.id).emit();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)apiKey));
    }

    @AuditInline
    @RequestMapping(value={"/api/publicapi/edit-personal-api-key"})
    public void editPersonalAPIKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam String label, @RequestParam String description) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.licenseEnforcementService.checkReadProjectContentAllowed(t.getUser());
            if (t.getUser().getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
                throw new SecurityException("Only users may do this");
            }
            PersonalPublicAPIKey personalApiKey = this.publicApiKeyService.getPersonalKeyById(id).orElseThrow(() -> ErrorContext.iae((String)"Key to delete not found"));
            AuthCtx ctx = this.authService.getMandatoryUser(req);
            if (!ctx.isAdmin() && !personalApiKey.user.equals(t.getUser().getAssociatedDSSUser())) {
                throw new SecurityException("You may not delete this API key");
            }
            this.publicApiKeyService.updatePersonalAPIKey(id, label, description);
            t.commit("Edited personal API key for  " + t.getUser().getAssociatedDSSUser() + ", id: " + id);
            this.auditService.generic("user-personal-apikey-edit").with("id", id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/publicapi/delete-personal-api-key"})
    public void deletePersonalAPIKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.licenseEnforcementService.checkReadProjectContentAllowed(t.getUser());
            if (t.getUser().getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
                throw new SecurityException("Only users may do this");
            }
            PersonalPublicAPIKey personalApiKey = this.publicApiKeyService.getPersonalKeyById(id).orElseThrow(() -> ErrorContext.iae((String)"Key to delete not found"));
            if (!personalApiKey.user.equals(t.getUser().getAssociatedDSSUser())) {
                throw new SecurityException("You may not delete this API key");
            }
            PersonalPublicAPIKey foundKey = this.publicApiKeyService.deletePersonalAPIKeyById(id);
            t.commit("Deleted personal API Key for " + t.getUser().getAssociatedDSSUser() + ", id: " + foundKey.id);
            this.auditService.generic("user-personal-apikey-delete").with("id", foundKey.id).emit();
        }
    }

    @AuditedCall(value={"msgType", "admin-personal-apikeys-list"})
    @RequestMapping(value={"/api/admin/publicapi/list-personal-api-keys"})
    public void adminListPersonalAPIKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<PersonalPublicAPIKey> personalKeys;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx ctx = this.authService.getMandatoryUser(req);
            if (!ctx.isAdmin()) {
                throw new SecurityException("You are not admin");
            }
            personalKeys = this.publicApiKeyService.getPersonalKeys();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, personalKeys);
    }

    @AuditedCall(value={"msgType", "admin-personal-apikey-delete"})
    @RequestMapping(value={"/api/admin/publicapi/delete-personal-api-key"})
    public void adminDeletePersonalAPIKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx ctx = this.authService.getMandatoryUser(req);
            if (!ctx.isAdmin()) {
                throw new SecurityException("You are not admin");
            }
            this.publicApiKeyService.deletePersonalAPIKeyById(id);
            t.commit("Deleted personal API Key");
        }
    }

    @AuditedCall(value={"msgType", "admin-update-apikeys-lifetime"})
    @RequestMapping(value={"/api/admin/publicapi/update-api-keys-lifetime"})
    public void updateApiKeysLifetime(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.publicApiKeyService.updateApiKeysLifetime();
            t.commit("Update existing API Keys lifetime");
        }
    }

    @UIModel
    public static class TaggableObjectRefOrAppRef {
        public final String projectKey;
        public final String type;
        public final String id;

        public TaggableObjectRefOrAppRef(String projectKey, String type, String id) {
            this.projectKey = projectKey;
            this.type = type;
            this.id = id;
        }

        public String toString() {
            return "{projectKey:" + this.projectKey + ", type:" + this.type + ", id:" + this.id + "}";
        }
    }

    public static class TestAzureADSettings {
        public AzureADSettings azureADSettings;
        public UserIdentity userIdentity;
    }

    public class AzureADTestSettingsResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public UserAttributes userAttributes;

        public AzureADTestSettingsResult(UserAttributes userAttributes) {
            this.connectionOK = true;
            this.userAttributes = userAttributes;
        }

        public AzureADTestSettingsResult(SerializedError connectionError) {
            this.connectionOK = false;
            this.connectionError = connectionError;
        }
    }
}

