/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityTemplate;
import com.dataiku.dip.dataquality.UIComputeRuleSelection;
import com.dataiku.dip.dataquality.UIRuleHistory;
import com.dataiku.dip.dataquality.rules.DataQualityBreakdown;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dss.shadelib.com.google.api.client.util.Preconditions;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/data-quality"})
public class DataQualityController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private DataQualitySummaryService dataQualitySummaryService;
    @Autowired
    private DataQualityRulesLaunchService launchService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    private void checkReadAccessWithOptionalContext(AuthCtx user, String projectKey, String datasetName, @Nullable String contextProjectKey) throws IOException, DKUSecurityException {
        if (StringUtils.isNotBlank((String)contextProjectKey)) {
            this.projectsService.failIfNoDatasetReadUseAccess(user, new AnyLoc(projectKey, datasetName), contextProjectKey);
        } else {
            this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
        }
    }

    @AuditedCall(value={"msgType", "data-quality-edit-config", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/save-config"}, method={RequestMethod.POST})
    public void saveConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam List<DataQualityRule> rules, @RequestParam MetricsEngineDesc.MetricsEngineConfig engineConfig) throws Exception {
        Map<String, String> result;
        ArrayList<DataQualityRule> originalRules;
        SerializedDataset dataset;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            originalRules = new ArrayList<DataQualityRule>(dataset.getDataQualityRuleSet().getRules());
            result = this.dataQualityService.saveConfig(dataset, rules, engineConfig, user);
            t.commit("Save data quality config on dataset " + datasetName);
        }
        Set<String> partitionsToRecompute = this.dataQualityService.getPartitionSetToRecompute_NT(rules, originalRules, dataset);
        if (!partitionsToRecompute.isEmpty()) {
            this.dataQualityService.updateDatasetStatusForPartitionsCascade_NT(dataset, partitionsToRecompute);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, result);
    }

    @AuditedCall(value={"msgType", "data-quality-get-config", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-config"}, method={RequestMethod.GET})
    public void getConfig(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        DataQualityService.DataQualityConfig config;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            config = this.dataQualityService.getConfig(projectKey, datasetName);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)config);
    }

    @AuditedCall(value={"msgType", "data-quality-set-monitoring", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "monitor", "${monitor}"})
    @RequestMapping(value={"/dataset/set-monitoring"}, method={RequestMethod.POST})
    public void setMonitoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<String> datasetNames, @RequestParam boolean monitor) throws Exception {
        ArrayList<SerializedDataset> updatedDatasets = new ArrayList<SerializedDataset>();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = t.getUser();
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            for (String datasetName : datasetNames) {
                SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
                if (!this.dataQualityService.setMonitoring(dataset, monitor, user)) continue;
                updatedDatasets.add(dataset);
            }
            if (updatedDatasets.size() == 1) {
                t.commit("Set monitoring on dataset" + ((SerializedDataset)updatedDatasets.get(0)).getFullName());
            } else if (updatedDatasets.size() > 1) {
                t.commit("Set monitoring on " + updatedDatasets.size() + "datasets in project " + projectKey);
            }
        }
        long currentTime = DateTime.now().getMillis();
        for (SerializedDataset dataset : updatedDatasets) {
            this.dataQualitySummaryService.updateDataQualityObjectStatus_NT(dataset.projectKey, dataset.name, currentTime, dataset.getDisplayName(), monitor, false);
        }
        if (!updatedDatasets.isEmpty()) {
            this.dataQualitySummaryService.updateDataQualityProjectStatus_NT(projectKey, currentTime);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)updatedDatasets.size());
    }

    @AuditedCall(value={"msgType", "data-quality-get-monitoring", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-monitoring"}, method={RequestMethod.GET})
    public void getMonitoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        boolean monitor;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            monitor = this.dataQualityService.getMonitoring(projectKey, datasetName);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)monitor);
    }

    @AuditedCall(value={"msgType", "data-quality-compute-rules-on-single-partition", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "ruleSelection", "${ruleSelection}", "partitionId", "${partitionId}"})
    @RequestMapping(value={"/dataset/compute-rules-on-single-partition"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport> computeRulesOnSinglePartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam UIComputeRuleSelection.RuleSelectionSpec ruleSelection, @RequestParam String partitionId, @RequestParam boolean isTestRun) throws Exception {
        SerializedDataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        DataQualityRulesLaunchService.RunOptions options = isTestRun ? DataQualityRulesLaunchService.RunOptions.testRun(!ruleSelection.excludeAutoRun()) : DataQualityRulesLaunchService.RunOptions.manualRun(!ruleSelection.excludeAutoRun());
        List<DataQualityRule> rules = dataset.getDataQualityRuleSet().checks.stream().filter(ruleSelection::matches).collect(Collectors.toList());
        return this.launchService.computeRulesOnSinglePartition(user, Dataset.fromSerialized(dataset), rules, partitionId, options);
    }

    @AuditedCall(value={"msgType", "data-quality-compute-rules-on-multiple-partitions", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "ruleSelection", "${ruleSelection}", "partitionSelection", "{partitionSelection}"})
    @RequestMapping(value={"/dataset/compute-rules-on-multiple-partitions"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Map<String, AbstractCheckReport.DataQualityRulesComputationReport>> computeRulesOnMultiplePartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam UIComputeRuleSelection.RuleSelectionSpec ruleSelection, @RequestParam UIComputeRuleSelection.MultiPartitionSelectionSpec partitionSelection, @RequestParam boolean isTestRun) throws Exception {
        SerializedDataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        DataQualityRulesLaunchService.RunOptions options = isTestRun ? DataQualityRulesLaunchService.RunOptions.testRun(!ruleSelection.excludeAutoRun()) : DataQualityRulesLaunchService.RunOptions.manualRun(!ruleSelection.excludeAutoRun());
        List<DataQualityRule> rules = dataset.getDataQualityRuleSet().checks.stream().filter(ruleSelection::matches).collect(Collectors.toList());
        if (partitionSelection instanceof UIComputeRuleSelection.MultiPartitionSelectionSpec.PartitionsSpec) {
            return this.launchService.computeRulesOnMultiplePartitions(user, Dataset.fromSerialized(dataset), rules, ((UIComputeRuleSelection.MultiPartitionSelectionSpec.PartitionsSpec)partitionSelection).partitionsSpec, partitionSelection.fullDataset, options);
        }
        if (partitionSelection instanceof UIComputeRuleSelection.MultiPartitionSelectionSpec.AllPartitions) {
            return this.launchService.computeRulesOnAllPartitions(user, Dataset.fromSerialized(dataset), rules, partitionSelection.fullDataset, options);
        }
        throw new IllegalStateException("Invalid partition selection");
    }

    @AuditedCall(value={"msgType", "get-dataset-current-daily-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-dataset-current-daily-status"})
    @ResponseBody
    public DataQualityDailyStatus getDatasetCurrentDailyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                this.projectsService.failIfNoDashboardPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey, SerializedProject.ReaderAuthorization.Mode.READ);
            } else {
                this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
            }
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        return this.dataQualityService.getDatasetStatusLast_NT(dataset);
    }

    @AuditedCall(value={"msgType", "get-current-status-breakdown", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-current-status-breakdown"})
    @ResponseBody
    public DataQualityBreakdown getDatasetCurrentStatusBreakdown(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)contextProjectKey)) {
                this.projectsService.failIfNoDashboardPermission(user, SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, datasetName, contextProjectKey), contextProjectKey, SerializedProject.ReaderAuthorization.Mode.READ);
            } else {
                this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName, SerializedProject.ReaderAuthorization.Mode.READ);
            }
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        return this.dataQualityService.getDatasetBreakDownLast_NT(dataset);
    }

    @AuditedCall(value={"msgType", "data-quality-get-dataset-status-last-each-partition", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-dataset-status-last-each-partition"})
    @ResponseBody
    public List<PartitionResult> getDatasetStatusLastEachPartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        return PartitionResult.fromOutcomeMap(this.dataQualityService.getDatasetStatusLastEachPartition_NT(dataset));
    }

    @AuditedCall(value={"msgType", "data-quality-get-dataset-status-timeline", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitionId", "${partitionId}", "startDay", "${startDay}", "endDay", "${endDay}"})
    @RequestMapping(value={"/dataset/get-dataset-status-timeline"})
    public void getDatasetStatusTimeline(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId, @RequestParam long startDay, @RequestParam long endDay) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        Preconditions.checkArgument((TimeUnit.MILLISECONDS.toDays(endDay - startDay) <= 90L ? 1 : 0) != 0, (Object)"Time frame must be within 90 days");
        List<DataQualityDailyStatus> timeline = this.dataQualityService.getDatasetStatusTimeline_NT(dataset, partitionId, startDay, endDay);
        DataQualityController.writeJSON((HttpServletResponse)resp, timeline);
    }

    @AuditedCall(value={"msgType", "data-quality-get-dataset-summary-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-dataset-summary-status"})
    public void getDatasetSummaryStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId, @RequestParam boolean allowDisabled) throws Exception {
        SerializedDataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        DataQualitySummaryService.UIDatasetDataQuality uiDq = this.dataQualitySummaryService.getDatasetDataQualityRules_NT(dataset, partitionId, allowDisabled);
        try (Transaction t = this.transactionService.beginRead();){
            this.dataQualitySummaryService.enrichAndRedactUIDatasetDataQuality(user, projectKey, uiDq);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)uiDq);
    }

    @AuditedCall(value={"msgType", "data-quality-get-dataset-summary-status-for-day", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-dataset-summary-status-for-day"})
    public void getDatasetSummaryStatusForDay(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId, @RequestParam long computeDay) throws Exception {
        SerializedDataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        long startOfDayTimestamp = new DateTime(computeDay).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
        DataQualitySummaryService.UIDatasetDataQuality uiDq = this.dataQualitySummaryService.getDatasetDataQualityRulesForDay_NT(dataset, partitionId, startOfDayTimestamp);
        try (Transaction t = this.transactionService.beginRead();){
            this.dataQualitySummaryService.enrichAndRedactUIDatasetDataQuality(user, projectKey, uiDq);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)uiDq);
    }

    @AuditedCall(value={"msgType", "data-quality-get-project-current-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/project/get-current-status"})
    public void getProjectCurrentStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        PublicUser owner;
        SerializedProject prj;
        List<SerializedDataset> sds;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sds = this.datasetsDAO.listUnsafe(projectKey);
            prj = this.projectsService.getMandatoryUnsafe(projectKey);
            owner = prj != null && prj.owner != null ? this.usersService.getPublicUser(prj.owner) : new PublicUser();
        }
        DataQualitySummaryService.UIProjectDataQuality projectStatus = this.dataQualitySummaryService.getProjectStatus_NT(prj, sds, owner, projectKey);
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)projectStatus);
    }

    @AuditedCall(value={"msgType", "get-project-current-daily-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/project/get-current-daily-status"})
    @ResponseBody
    public DataQualityDailyStatus getProjectCurrentDailyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.dataQualityService.getProjectStatusLast_NT(projectKey);
    }

    @AuditedCall(value={"msgType", "get-current-status-breakdown", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/project/get-current-status-breakdown"})
    @ResponseBody
    public DataQualityBreakdown getProjectCurrentBreakdown(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.dataQualityService.getProjectBreakDownLast_NT(projectKey);
    }

    @AuditedCall(value={"msgType", "data-quality-get-project-status-timeline", "projectKey", "${projectKey}", "startDay", "${startDay}", "endDay", "${endDay}"})
    @RequestMapping(value={"/project/get-status-timeline"})
    public void getProjectStatusTimeline(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam long startDay, @RequestParam long endDay) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        Preconditions.checkArgument((TimeUnit.MILLISECONDS.toDays(endDay - startDay) <= 90L ? 1 : 0) != 0, (Object)"Time frame must be within 90 days");
        List<DataQualityDailyStatus> timeline = this.dataQualityService.getProjectStatusTimeline_NT(projectKey, startDay, endDay);
        DataQualityController.writeJSON((HttpServletResponse)resp, timeline);
    }

    @AuditedCall(value={"msgType", "data-quality-get-project-summary-status-for-day", "projectKey", "${projectKey}", "computeDay", "${computeDay}"})
    @RequestMapping(value={"/project/get-project-summary-status-for-day"})
    public void getProjectSummaryStatusForDay(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam long computeDay) throws Exception {
        List<SerializedDataset> sds;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sds = this.datasetsDAO.listUnsafe(projectKey);
        }
        long startOfDayTimestamp = new DateTime(computeDay).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
        List<DataQualitySummaryService.UIDProjectDatasetDataQuality> datasets = this.dataQualitySummaryService.getProjectSummaryStatusForDay_NT(projectKey, sds, startOfDayTimestamp);
        DataQualityController.writeJSON((HttpServletResponse)resp, datasets);
    }

    @AuditedCall(value={"msgType", "data-quality-get-dataset-rule-history", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/get-dataset-rule-history"}, method={RequestMethod.POST})
    public void getDatasetRuleHistory(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam UIRuleHistory.PageFilters filters) throws Exception {
        SerializedDataset dataset;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        UIRuleHistory.RuleFetchResult result = this.dataQualityService.getDatasetRuleHistory_NT(dataset, filters);
        try (Transaction t = this.transactionService.beginRead();){
            this.dataQualitySummaryService.enrichUIRuleHistory(user, projectKey, result);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "data-quality-has-dataset-rule-history", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/dataset/has-dataset-rule-history"}, method={RequestMethod.POST})
    public void hasDatasetRuleHistory(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam @Nullable List<String> partitionList) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)this.dataQualityService.hasDatasetRuleHistory_NT(dataset, partitionList));
    }

    @AuditedCall(value={"msgType", "data-quality-get-all-rules-that-existed", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitionId", "${partitionId}"})
    @RequestMapping(value={"/dataset/get-all-rules-that-existed"})
    public void getAllRulesThatExisted(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)this.dataQualityService.getAllRulesThatExisted_NT(dataset, partitionId));
    }

    @AuditedCall(value={"msgType", "get-monitored-project-summary-statuses"})
    @RequestMapping(value={"/get-monitored-project-summary"})
    public void getInstanceSummary(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<ProjectsService.UIProject> projects;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            projects = this.projectsService.listAccessibleUnsafe(user, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        List<DataQualitySummaryService.UIMonitoredProject> monitoredProjects = this.dataQualitySummaryService.getMonitoredProjects_NT(projects);
        DataQualityController.writeJSON((HttpServletResponse)resp, (Object)new DataQualitySummaryService.UIInstanceDataQuality(projects.size(), monitoredProjects));
    }

    @AuditedCall(value={"msgType", "get-last-run-partitions"})
    @RequestMapping(value={"/last-run-partitions"})
    @ResponseBody
    public List<PartitionResult> getLastRunPartitions(HttpServletRequest req, @RequestParam(required=false) String contextProjectKey, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.checkReadAccessWithOptionalContext(user, projectKey, datasetName, contextProjectKey);
        }
        return PartitionResult.fromOutcomeMap(this.dataQualityService.getLastRunPartitions_NT(projectKey, datasetName));
    }

    @AuditedCall(value={"msgType", "delete-partition-history", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitionId", "${partitionId}"})
    @RequestMapping(value={"/delete-partition-history"}, method={RequestMethod.POST})
    @ResponseBody
    public void deletePartitionHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        this.dataQualityService.deletePartitionHistory(dataset, partitionId);
    }

    @AuditedCall(value={"msgType", "data-quality-templates-list"})
    @RequestMapping(value={"/list-templates"})
    @ResponseBody
    public List<DataQualityTemplate> listTemplates(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            List<DataQualityTemplate> list = this.dataQualityService.listDataQualityTemplatesUnsafe();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "data-quality-templates-get", "id", "${id}"})
    @RequestMapping(value={"/get-template"})
    @ResponseBody
    public DataQualityTemplate getTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            DataQualityTemplate dataQualityTemplate = this.dataQualityService.getDataQualityTemplateMandatoryUnsafe(id);
            return dataQualityTemplate;
        }
    }

    @AuditInline
    @RequestMapping(value={"/create-template"}, method={RequestMethod.POST})
    @ResponseBody
    public DataQualityTemplate createTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String description, @RequestParam List<DataQualityRule> rules) throws Exception {
        DataQualityTemplate template;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkWriteProjectContentAllowed(user);
            template = this.dataQualityService.createTemplate(name, description, rules);
            t.commit("Created data quality template with id " + template.getId());
            this.auditTrailService.generic("data-quality-templates-create").with("id", template.getId()).emit();
        }
        return template;
    }

    @AuditInline
    @RequestMapping(value={"/update-template"}, method={RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> updateTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam DataQualityTemplate template) throws Exception {
        Map<String, String> result;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkWriteProjectContentAllowed(user);
            result = this.dataQualityService.updateTemplate(template);
            t.commit("Updated data quality template with id " + template.getId());
            this.auditTrailService.generic("data-quality-templates-update").with("id", template.getId()).emit();
        }
        return result;
    }

    @AuditedCall(value={"msgType", "data-quality-templates-delete", "id", "${id}"})
    @RequestMapping(value={"/delete-template"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteTemplate(HttpServletRequest req, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkWriteProjectContentAllowed(user);
            this.dataQualityService.deleteTemplate(id);
            t.commit("Deleted data quality template with id " + id);
        }
    }

    @UIModel
    public static class PartitionResult {
        public final String partitionId;
        @Nullable
        public final AbstractCheckContext.CheckOutcome outcome;

        public PartitionResult(String partitionId, @Nullable AbstractCheckContext.CheckOutcome outcome) {
            this.partitionId = partitionId;
            this.outcome = outcome;
        }

        public static List<PartitionResult> fromOutcomeMap(Map<String, AbstractCheckContext.CheckOutcome> map) {
            return map.entrySet().stream().map(e -> new PartitionResult((String)e.getKey(), (AbstractCheckContext.CheckOutcome)((Object)((Object)e.getValue())))).collect(Collectors.toList());
        }
    }
}

