/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesClusterService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class KubernetesClusterController
extends DIPInternalControllerBase {
    @Autowired
    private KubernetesClusterService kubernetesClusterService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;

    @AuditedCall(value={"msgType", "clusters-k8s-kubectl-command", "clusterId", "${clusterId}", "args", "${args}"})
    @RequestMapping(value={"/api/clusters/k8s/actions/run-kubectl"})
    public void runKubectlCommand(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String args) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.permissionsService.checkAdmin(authCtx);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.futureRunKubectlCommand(authCtx, clusterId, KubectlHelper.parseCommand(args)));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-finished-jobs", "clusterId", "${clusterId}", "deleteFailed", "${deleteFailed}"})
    @RequestMapping(value={"/api/clusters/k8s/jobs/actions/delete-finished"}, method={RequestMethod.POST})
    public void deleteFinishedJobs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam boolean dryRun, @RequestParam boolean deleteFailed, @RequestParam String namespace, @RequestParam String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.deleteFinishedJobs(authCtx, clusterId, dryRun, deleteFailed, namespace, labelFilter));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-finished-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/pods/actions/delete-finished"}, method={RequestMethod.POST})
    public void deleteFinishedPods(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam(defaultValue="true") boolean dryRun, @RequestParam String namespace, @RequestParam String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.deleteFinishedPods(authCtx, clusterId, dryRun, namespace, labelFilter));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-delete-all-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/pods/actions/delete-all"}, method={RequestMethod.POST})
    public void deleteAllPods(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam(defaultValue="true") boolean dryRun, @RequestParam String namespace, @RequestParam String labelFilter) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.deleteAllPods(authCtx, clusterId, dryRun, namespace, labelFilter));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-count-nodes-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/count-nodes-and-pods"})
    public void getNodesAndPodsCount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.countNodesAndPods(authCtx, clusterId));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-has-metrics-server", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/has-metrics-server"})
    public void checkMetricsServerInstalled(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.checkMetricsServerInstalled(authCtx, clusterId));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-retrieve-nodes-metrics", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/nodes-metrics"})
    public void getNodesMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.getNodesMetrics(authCtx, clusterId));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-namespaces", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/namespaces"})
    public void getNamespaces(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listNamespaces(authCtx, clusterId));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-nodes", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/nodes"})
    public void getNodes(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam(required=false, defaultValue="false") boolean detailedNodeData) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listNodes(authCtx, clusterId, detailedNodeData));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-pods", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/pods"})
    public void getPods(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam KubernetesClusterService.NamespaceFilterType namespaceFilterType, @RequestParam(required=false) String namespace, @RequestParam(required=false, defaultValue="false") boolean detailedPodData) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listPods(authCtx, clusterId, namespaceFilterType, namespace, detailedPodData));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-jobs", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/jobs"})
    public void getJobs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam KubernetesClusterService.NamespaceFilterType namespaceFilterType, @RequestParam(required=false) String namespace) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listJobs(authCtx, clusterId, namespaceFilterType, namespace));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-deployments", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/deployments"})
    public void getDeployments(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam KubernetesClusterService.NamespaceFilterType namespaceFilterType, @RequestParam(required=false) String namespace) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listDeployments(authCtx, clusterId, namespaceFilterType, namespace));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-services", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/services"})
    public void getServices(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam KubernetesClusterService.NamespaceFilterType namespaceFilterType, @RequestParam(required=false) String namespace) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.listServices(authCtx, clusterId, namespaceFilterType, namespace));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-describe-object", "clusterId", "${clusterId}", "objectType", "${objectType}", "objectName", "${objectName}", "namespace", "${namespace}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/describe-object"})
    public void describeClusterObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String objectType, @RequestParam String objectName, @RequestParam(required=false) String namespace) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.describeObject(authCtx, clusterId, objectType, objectName, namespace));
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-delete-object", "clusterId", "${clusterId}", "objectType", "${objectType}", "objectName", "${objectName}", "namespace", "${namespace}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/delete-object"})
    public void deleteClusterObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String objectType, @RequestParam String objectName, @RequestParam String namespace) throws Exception {
        AuthCtx authCtx = this.getAuthCtx_NT(req);
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        KubernetesClusterController.writeJSON((HttpServletResponse)resp, this.kubernetesClusterService.deleteObject(authCtx, clusterId, objectType, objectName, namespace));
    }

    @AuditedCall(value={"msgType", "k8s-cluster-monitoring-tail-pod-log", "clusterId", "${clusterId}", "podName", "${podName}", "namespace", "${namespace}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/tail-pod-log"})
    @ResponseBody
    public SmartLogTail tailPodLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String podName, @RequestParam String namespace) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        return this.kubernetesClusterService.tailPodLog(authCtx, clusterId, podName, namespace);
    }

    @AuditedCall(value={"msgType", "clusters-k8s-monitoring-stream-pod-log", "clusterId", "${clusterId}", "podName", "${podName}", "namespace", "${namespace}"})
    @RequestMapping(value={"/api/clusters/k8s/monitoring/stream-pod-log"})
    public void streamPodLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String podName, @RequestParam String namespace) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        this.kubernetesClusterService.checkClusterUpdatePrivilegeAndArchitecture_NT(authCtx, clusterId);
        String now = DKUtils.getDateFormatter((String)"_yyyy_MM_dd").print(new Date().getTime());
        String dlName = podName + now + ".log.gz";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.kubernetesClusterService.getPodLog(authCtx, clusterId, podName, namespace, (OutputStream)resp.getOutputStream());
    }

    private AuthCtx getAuthCtx_NT(HttpServletRequest req) throws IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            return authCtx;
        }
    }
}

