/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.ETaggedResponseBody;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.staticdata.AbstractStaticData;
import com.dataiku.dip.server.staticdata.ChartsCustomExpressionSyntax;
import com.dataiku.dip.server.staticdata.ChartsCustomFormulasFunctions;
import com.dataiku.dip.server.staticdata.CmlDiagnosticsDefinition;
import com.dataiku.dip.server.staticdata.CmlGuessPolicies;
import com.dataiku.dip.server.staticdata.CustomExpressionSyntax;
import com.dataiku.dip.server.staticdata.CustomFormulasFunctions;
import com.dataiku.dip.server.staticdata.DatasetCommonCharsets;
import com.dataiku.dip.server.staticdata.DatasetFormatTypes;
import com.dataiku.dip.server.staticdata.DatasetTypes;
import com.dataiku.dip.server.staticdata.MLCommonDiagnosticsDefinition;
import com.dataiku.dip.server.staticdata.PmlDiagnosticsDefinition;
import com.dataiku.dip.server.staticdata.PmlGuessPolicies;
import com.dataiku.dip.server.staticdata.TimezonesList;
import com.dataiku.dip.server.staticdata.TimezonesShortList;
import com.dataiku.dip.server.staticdata.WebAppTypes;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class StaticDataController
extends DIPInternalControllerBase {
    @Autowired
    TranslationService staticTranslationService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/static-data"})
    @ETaggedResponseBody
    public Map<String, Object> getStaticData(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String lang) throws IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return Stream.of(new CustomFormulasFunctions(), new ChartsCustomFormulasFunctions(), new CustomExpressionSyntax(this.staticTranslationService, lang), new ChartsCustomExpressionSyntax(this.staticTranslationService, lang), new DatasetCommonCharsets(), new DatasetFormatTypes(this.staticTranslationService, lang), new DatasetTypes(), new PmlGuessPolicies(), new CmlGuessPolicies(), new TimezonesList(), new TimezonesShortList(), new WebAppTypes(), new PmlDiagnosticsDefinition(lang), new MLCommonDiagnosticsDefinition(lang), new CmlDiagnosticsDefinition(lang)).collect(Collectors.toMap(AbstractStaticData::getKey, AbstractStaticData::getData));
    }
}

