/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code;

import com.dataiku.dip.DKUApp;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public interface CodeRenamer {
    public List<String> getRecipeTypes();

    public boolean requiresRenaming(String var1);

    public String updatePayload(String var1);

    default public boolean shouldSkipRenamingForPayload(String payload) {
        long maxBytesSizeForRenaming = DKUApp.getParams().getLongParam("dku.fileSizeBytesLimit.datasetRenaming", 102400L);
        return payload == null || maxBytesSizeForRenaming < (long)payload.getBytes(StandardCharsets.UTF_8).length;
    }

    public static String getReplacementMessage(String oldName, String newName, String user, Date date) {
        StringBuilder sb = new StringBuilder("Dataset ");
        sb.append(oldName);
        sb.append(" renamed to ");
        sb.append(newName);
        if (StringUtils.isNotEmpty((String)user)) {
            sb.append(" by ");
            sb.append(user);
        }
        if (date != null) {
            sb.append(" on ");
            sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
        }
        sb.append("\n");
        return sb.toString();
    }
}

