/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PermissionsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SharedSecretAuthService sharedSecretAuthService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-dataset-privilege"})
    public void checkDatasetPrivilege(HttpServletRequest req, HttpServletResponse resp, @RequestParam String datasetFullName, @RequestParam String privilege) throws Exception {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasetFullName);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkDatasetPrivileges(tu.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.valueOf(privilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-dataset-read-privilege"})
    public void checkDatasetReadPrivilege(HttpServletRequest req, HttpServletResponse resp, @RequestParam String datasetFullName, @RequestParam String privilege) throws Exception {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasetFullName);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            if (this.projectsService.hasDatasetReadAccessRegardlessOfContext(tu.getAuthCtx(), loc)) {
                return;
            }
            this.permissionsService.checkDatasetPrivileges(tu.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.valueOf(privilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-taggable-object-read-use-privilege"})
    public void checkTaggableObjectReadUsePrivilege(HttpServletRequest req, HttpServletResponse resp, @RequestParam TaggableObjectsService.TaggableObjectRef taggableObjectRef, @RequestParam String contextProjectKey) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoReadAccess(tu.getAuthCtx(), taggableObjectRef, contextProjectKey);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-project-privilege"})
    public void checkProjectPrivilege(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(tu.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.valueOf(privilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/has-project-privilege"})
    public void hasProjectPrivilege(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasProjectPrivilege(tu.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-cluster-privilege"})
    public void checkClusterPrivilegeTicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkClusterPrivileges(tu.getAuthCtx(), clusterId, Privileges.ClusterLevelPrivilegeType.valueOf(privilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/permissions/check-cluster-privilege"})
    public void checkClusterPrivilegeSharedSecret(HttpServletRequest req, HttpServletResponse resp, @RequestParam String authCtx, @RequestParam String clusterId, @RequestParam String privilege) throws Exception {
        this.sharedSecretAuthService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkClusterPrivileges((AuthCtx)JSON.parse((String)authCtx, DSSAuthCtx.class), clusterId, Privileges.ClusterLevelPrivilegeType.valueOf(privilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/has-plugin-privilege"})
    public void hasPluginPrivilegeTicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginPrivilege(tu.getAuthCtx(), pluginId, Privileges.PluginLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/permissions/has-plugin-privilege"})
    public void hasPluginPrivilegeSharedSecret(HttpServletRequest req, HttpServletResponse resp, @RequestParam String authCtx, @RequestParam String pluginId, @RequestParam String privilege) throws Exception {
        this.sharedSecretAuthService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginPrivilege((AuthCtx)JSON.parse((String)authCtx, DSSAuthCtx.class), pluginId, Privileges.PluginLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/has-plugin-preset-privilege"})
    public void hasPluginPresetPrivilegeTicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String projectKey, @RequestParam String presetName, @RequestParam String parameterSetId, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginPresetPrivilege(tu.getAuthCtx(), pluginId, projectKey, presetName, parameterSetId, Privileges.PluginPresetLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/permissions/has-plugin-preset-privilege"})
    public void hasPluginPresetPrivilegeSharedSecret(HttpServletRequest req, HttpServletResponse resp, @RequestParam String authCtx, @RequestParam String pluginId, @RequestParam String projectKey, @RequestParam String presetName, @RequestParam String parameterSetId, @RequestParam String privilege) throws Exception {
        this.sharedSecretAuthService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginPresetPrivilege((AuthCtx)JSON.parse((String)authCtx, DSSAuthCtx.class), pluginId, projectKey, presetName, parameterSetId, Privileges.PluginPresetLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/has-plugin-parameter-set-privilege"})
    public void hasPluginParameterSetPrivilegeTicket(HttpServletRequest req, HttpServletResponse resp, @RequestParam String pluginId, @RequestParam String parameterSetName, @RequestParam String privilege) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginParameterSetPrivilege(tu.getAuthCtx(), pluginId, parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/permissions/has-plugin-parameter-set-privilege"})
    public void hasPluginParameterSetPrivilegeSharedSecret(HttpServletRequest req, HttpServletResponse resp, @RequestParam String authCtx, @RequestParam String pluginId, @RequestParam String parameterSetName, @RequestParam String privilege) throws Exception {
        this.sharedSecretAuthService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            boolean hasPrivilege = this.permissionsService.hasPluginParameterSetPrivilege((AuthCtx)JSON.parse((String)authCtx, DSSAuthCtx.class), pluginId, parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType.valueOf(privilege));
            PermissionsIntercomController.writeJSON((HttpServletResponse)resp, (Object)new PermissionCheckResult(hasPrivilege));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/permissions/check-sql-connection-direct-use-policy-hook"})
    public void checkSQLConnectionUsePolicyHook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String connection) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            this.customPolicyHooksRegistry.onPreSQLConnectionDirectUse(tu.getAuthCtx(), projectKey, connection);
        }
    }

    public static class PermissionCheckResult {
        public boolean ok;

        public PermissionCheckResult(boolean ok) {
            this.ok = ok;
        }
    }
}

