/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrLookup;

public class VariableLookup
extends StrLookup {
    private final MemTable table;
    private final MemRow row;
    private VariablesContext vc;
    private Map<String, Object> rawMap = new HashMap<String, Object>();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.reporter.lookup");

    public VariableLookup() {
        this.table = new MemTable();
        this.row = new MemRow(this.table);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.table.columnsList.size(); ++i) {
            sb.append(this.table.columnsList.get(i).getName());
            sb.append('\t');
            sb.append(this.row.getFast(i));
            sb.append('\n');
        }
        if (this.vc != null) {
            sb.append(JSON.pretty((Object)this.vc.getAllVariablesTyped()));
        }
        return sb.toString();
    }

    public void setVariablesContext(VariablesContext vc) {
        this.vc = vc;
    }

    public void addVariable(String name, Object result) {
        this.rawMap.put(name, result);
        if (result instanceof Map) {
            for (Map.Entry sub : ((Map)result).entrySet()) {
                this.addVariable(this.table, this.row, name + "_" + (String)sub.getKey(), sub.getValue());
            }
        }
        this.addVariable(this.table, this.row, name, result);
    }

    public void addVariables(Map<String, String> variables) {
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            this.addVariable(variable.getKey(), variable.getValue());
        }
    }

    private void addVariable(MemTable table, MemRow row, String name, Object result) {
        MemColumn column = table.column(name);
        if (result == null || result instanceof String) {
            row.put((Column)column, (String)result);
        } else if (result instanceof Integer) {
            row.put((Column)column, String.valueOf((Integer)result));
        } else if (result instanceof Boolean) {
            row.put((Column)column, String.valueOf((Boolean)result));
        } else if (result instanceof Double) {
            row.put((Column)column, String.valueOf((Double)result));
        } else {
            row.put((Column)column, JSON.json((Object)result));
        }
    }

    public Object typedGetResolved(String var) throws Exception {
        Object evaluated = null;
        if (this.rawMap.containsKey(var)) {
            return this.rawMap.get(var);
        }
        try {
            Expression ge = new Expression(var);
            ge.setColumnFactory(this.table);
            ge.setVariablesContext(this.vc);
            evaluated = ge.evaluateWithRawTypes(this.row);
            if (evaluated instanceof ExpressionError) {
                logger.info((Object)("Failure during evaluation of'" + var + "' as formula: " + String.valueOf(evaluated)));
                throw new Exception(((ExpressionError)evaluated).message);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Cannot evaluate expression '" + var + "' as formula"), (Throwable)ex);
            throw ex;
        }
        return evaluated;
    }

    public String lookup(String var) {
        try {
            return this.lookupWithSyntaxError(var);
        }
        catch (Exception ex) {
            logger.info((Object)("Cannot evaluate expression '" + var + "' as formula"), (Throwable)ex);
            return null;
        }
    }

    public String lookupWithSyntaxError(String var) {
        if (this.table.columns.containsKey(var)) {
            return this.row.get(this.table.column(var));
        }
        Expression ge = new Expression(var);
        ge.setColumnFactory(this.table);
        ge.setVariablesContext(this.vc);
        Object evaluated = ge.evaluate(this.row);
        if (evaluated instanceof ExpressionError) {
            logger.info((Object)("Failure during evaluation of'" + var + "' as formula: " + String.valueOf(evaluated)));
            return null;
        }
        logger.info((Object)("Evaluated to " + String.valueOf(evaluated)));
        return evaluated != null ? evaluated.toString() : null;
    }

    public Object rawGet(String name) throws TemplateModelException {
        Object o = this.rawMap.get(name);
        if (o == null && this.vc != null && this.vc.has(name)) {
            o = this.vc.lookup(name);
        }
        return o;
    }

    public Map<String, String> getAllVariablesForEnv() {
        HashMap variables = Maps.newHashMap();
        if (this.vc != null) {
            variables.putAll(this.vc.getAllVariables());
        }
        for (Column column : this.table.columns()) {
            variables.put(column.getName(), this.row.get(column));
        }
        return variables;
    }

    public JsonObject getAllVariablesTyped() {
        JsonObject variables = new JsonObject();
        if (this.vc != null) {
            for (Map.Entry<String, Object> p : this.vc.getAllVariablesTyped().entrySet()) {
                variables.add(p.getKey(), (JsonElement)p.getValue());
            }
        }
        for (Map.Entry<String, Object> p : this.rawMap.entrySet()) {
            variables.add(p.getKey(), JSON.toJsonElement((Object)p.getValue()));
        }
        return variables;
    }
}

